#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Morph.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
const  float Morph::figureA[][3] = {{0,0,0}, {3,3,0}, {6,0,0}, {6,-6,0},
                   {4,-6,0}, {4,-4,0}, {2,-4,0}, {2,-6,0},
                   {0,-6,0}};
const  float Morph::figureB[][3] = {{0,0,0}, {3,0,0}, {6,0,0}, {6,-2,0},
		   {4,-2,0}, {4,-6,0}, {2,-6,0}, {2,-2,0},
		   {0,-2,0}};

Morph::Morph ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "morph.vert",  &vsSource);
  readShaderFile( (char *) "morph.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;
}

void Morph::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int posHandle = glGetAttribLocation(program,"vPosition");
  int posHandle1 = glGetAttribLocation(program,"vPosition1");
  if ( posHandle1 == -1)
     printf("No such uniform named %s\n", "vPosition1" );
  glEnableVertexAttribArray( posHandle );
  glEnableVertexAttribArray( posHandle1 );
  glVertexAttribPointer(posHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, figureA);
  glVertexAttribPointer(posHandle1, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, figureB);

  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  // get handle to fragment shader's uniform variable vColor
  int colorHandle =  glGetUniformLocation(program, "vColor");
  if ( colorHandle == -1 )
    printf("No such uniform named vColor\n");
  //timeHandle and Npoints are data members of class
  timeHandle =  glGetUniformLocation(program, "timeStep");
  if ( timeHandle == -1 )
    printf("No such uniform named timeStep\n");

  glUniform4f(colorHandle,  0, 1, 0, 1);  //green color
  glDrawArrays( GL_LINE_LOOP, 0, Npoints );
  glDisableVertexAttribArray(posHandle);
  glDisableVertexAttribArray(posHandle1);
}

void Morph::setTime ( float t )
{
  glUniform1f ( timeHandle, t );   // send the timeStep to vertex shader
}
