#include <iostream>
#include "Ray.h"
#include "Plane.h"
#include "Box.h"
#include "Triangle.h"
#include "Sphere.h"
#include "intersect.h"

int main()
{
  Ray r;
  Plane plane;
  Point3 pl ( 1, 1, 1 );
  Point3 ph ( 2, 2, 2 );
  Box box ( pl, ph  );

  //Ray ray ( Point3 ( 0, 0, 0 ), Vector3 ( 1, 1, 1 ) );
  Ray ray ( Point3 ( 1.5, 0, 0 ), Vector3 ( 0, 1, 1 ) );
  bool hit = false;
  double t1, t2;

  hit = intersect_ray_box ( ray,  box, t1, t2 ); 
  if ( !hit ) {
     cout << "Missed box!" << endl;
  } else {
     cout << "Hit box!" << endl;
     Point3 p;
     p = ray.getPoint ( t1 );
     p.print(); 
  }

  Point3 p0 ( 1, 1, 1 );
  Point3 p1 ( 4, 4, 4 );
  Point3 p2 ( 3, 6, 3 );
  Triangle tri ( p0, p1, p2 );
  Sphere s1;
  Sphere s2 ( 2 );
  Point3 ps ( 2, 2, 0 );
  Sphere s3 ( ps, 3.0 );

  //Vector3 D ( 1, 0, 0 ); 
  Vector3 D ( 0, 0, 1 ); 
  //Vector3 D ( 0, 0, 1 ); 
  //Ray r1 ( Point3 ( 0, 0, 0 ), D  );
  Ray r1 ( ps, D  );

  double t;
  hit = intersect_ray_sphere ( r1, s3, t );

  if ( hit ) {
    cout << "Hit sphere, t= " << t << "\n";
    Point3 p = r1.getPoint ( t );
    p.print();  
  }  else {
    cout << "Miss sphere \n";
  } 

  return 0;
}
