/*
  triangle.h
*/
#ifndef TRIANGLE_H
#define TRIANGLE_H

#include "Point3.h"
#include "Vector3.h"
#include "Object.h"
#include <math.h>
#include <stdio.h>

using namespace std;

class Triangle : Object {
public:
  Point3 p0;		//three points determine a triangle
  Point3 p1;		
  Point3 p2;		
  
  Triangle ()
  {
    p0 = Point3( 0.0, 0.0, 0.0 );
    p1 = Point3( 1.0, 0.0, 0.0 );
    p2 = Point3( 0.0, 1.0, 0.0 );
    kind = TRIANGLE;
  }
  Triangle ( const Point3 &v0, const Point3 &v1, const Point3 &v2 )
  {
    p0 = v0;
    p1 = v0;
    p2 = v2;
    kind = TRIANGLE;
  }
};

#endif
