/*
  plane.h
  Note: A point and a normal specifies a plane.
*/
#ifndef PLANE_H
#define PLANE_H

#include "Vector3.h"
#include "Point3.h"
#include <math.h>

using namespace std;

class Plane {
public:
  Point3 p0;		//one point and a normal define a plane
  Vector3	 n;
  Plane (){		//default is xy plane 
    p0 = Point3( 0.0, 0.0, 0.0 );
    n = Vector3 ( 0, 0, 1 ) ;
  }
  Plane ( const Point3 &aPoint,  const Vector3 & aNormal )
  {
    p0 = aPoint;
    n = aNormal;
    if ( n.magnitude() == 0 )     //special case
      n = Vector3 ( 0, 0, 1 );
    else
      n.normalize();             //make it a unit vector
  }
};

#endif
