/*
 * phong.cpp
 * Demonstration of Phone lighting model.
 */
#include <GL/glut.h>
#include <stdlib.h>

/*  Initialize material property, light source, lighting model,
 *  and depth buffer.
 */
void init(void) 
{
   //Material properties: reflectivity coefficients
   GLfloat mat_specular[] = { 0.6, .8, 1, 1.0 };
   GLfloat mat_ambient[] = { 0.1, 0.1, 0.1, 1.0 };
   GLfloat mat_diffuse[] = { 0.6, 0.4, 0.2, 1.0 };
   GLfloat mat_shininess0[] = { 20.0}; 
   GLfloat mat_shininess1[] = { 100.0}; 
   //Light properties
   GLfloat light_position0[] = { 1.0, 1.0, 1.0, 0.0 };  //directional light
   GLfloat light0[] = { 1, 1, 1 };  //light source 0
   GLfloat light1[] = {1, 1, 1 };   //light source 1
   GLfloat light_position1[] = { 1.0, 1.0, 0.0, 0.0 };  //directional light


   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_SMOOTH);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess0);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
   glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
   
   glLightfv(GL_LIGHT0, GL_POSITION, light_position0);

   glLightfv(GL_LIGHT0, GL_DIFFUSE, light0 );
   glLightfv(GL_LIGHT0, GL_AMBIENT, light0 );
   glLightfv(GL_LIGHT0, GL_SPECULAR, light0 );

   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess1);
   glLightfv(GL_LIGHT1, GL_DIFFUSE, light1 );
   glLightfv(GL_LIGHT1, GL_AMBIENT, light1 );
   glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
   glLightfv(GL_LIGHT1, GL_SPECULAR, light1 );

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_LIGHT1);
   glEnable(GL_DEPTH_TEST);
}

void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glutSolidSphere (0.5, 64, 64);

   glFlush ();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,
         1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
   else
      glOrtho (-1.5*(GLfloat)w/(GLfloat)h,
         1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
