//checker_tex.cpp
//Use computer-generated checker board image as texture.
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>

const int width = 256, height = 256;
unsigned char board[width][height][4];

GLuint handle;

void getBoard(void)
{
   int  c;
   
   for ( int i = 0; i < width; i++ ) {
      for ( int j = 0; j < height; j++ ) {	//start from lower-left corner
         c = ((((i&16)==0)^((j&16))==0))*255;   //0 or 255 --> black or white
         board[i][j][0] =  c;	//red component
         board[i][j][1] =  c;	//green component
         board[i][j][2] =  c;	//blue  component
         board[i][j][3] =  255; //alpha	
      }
   }
}

void init(void)
{  
   glClearColor (0.8, 0.8, 1.0, 1.0);
   glShadeModel(GL_FLAT);
   glEnable(GL_DEPTH_TEST);
   getBoard();

   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

   glGenTextures(1, &handle);
   glBindTexture(GL_TEXTURE_2D, handle);

   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
                   GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
                   GL_NEAREST);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height,
                0, GL_RGBA, GL_UNSIGNED_BYTE, board);
}

void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();             // clear the matrix 
   glFrustum (-2.5, 2.5, -2.5, 2.5, 5, 20.0);
   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt ( 0.0, 0.0, 5.5, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

   glEnable(GL_TEXTURE_2D);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   glBindTexture(GL_TEXTURE_2D, handle);
   glBegin(GL_QUADS);
   glTexCoord2f(0.0, 0.0); glVertex3f(-2.0, -2.0, 0.0);
   glTexCoord2f(1.0, 0.0); glVertex3f( 0.0, -2.0, 0.0); 
   glTexCoord2f(1.0, 1.0); glVertex3f(0.0, 0.0, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f(-2.0, 0.0, 0.0);

   glTexCoord2f(0.0, 0.0); glVertex3f(0.5, -2.0, 0.0);
   glTexCoord2f(1.0, 0.0); glVertex3f( 2.5, -1.5, 0.0); 
   glTexCoord2f(1.0, 1.0); glVertex3f( 2.5, 0.5, 0.0);
   glTexCoord2f(0.0, 1.0); glVertex3f( 0.5, 0.0, 0.0);
   glEnd();
   glFlush();
}


void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGBA | GLUT_DEPTH);
   glutInitWindowSize(400, 400);
   glutInitWindowPosition(100, 100);
   glutCreateWindow(argv[0]);
   init();
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0; 
}
