/*
 * readppm.cpp
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <iostream>
#include "ppmfun.h"

using namespace std;

GLfloat diffuseMaterial[4] = { 0.5, 0.5, 0.5, 1.0 };

void init(void)
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };

   glShadeModel (GL_SMOOTH);
   glEnable(GL_DEPTH_TEST);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

   glColorMaterial(GL_FRONT, GL_DIFFUSE);
   glEnable(GL_COLOR_MATERIAL);

}
  
void save_ppmRGB ( FILE *fp, unsigned char *p, int width, int height )
{
  //save data up-side-down 
  int k;
  for ( int i = 0; i < height; i++ ) {
    k = (height - 1 - i) * width * 3;
   for ( int j = 0; j < width; j++ ) {
       putc( p[k++], fp );
       putc( p[k++], fp );
       putc( p[k++], fp );
    }
  }   
}
 
void read_ppm_image( char *n1, float x0, float y0 )
{
  FILE *fpi = fopen( n1, "rb");

  if ( fpi == NULL ) {
    printf("\nError opening file %s!\n", n1);
    return;
  }

  int width, height, c, colorlevels;;
  unsigned char *imgBuffer;
  char temp[100];
 
  ppm_read_comments ( fpi );
  fscanf ( fpi, "%2s", temp );
  temp[3] = 0;
  if ( strncmp ( temp, "P6", 2 ) )
    throw ppm_error();
  ppm_read_comments ( fpi );
  fscanf ( fpi, "%d", &width );
  ppm_read_comments ( fpi );
  fscanf ( fpi, "%d", &height );
  ppm_read_comments ( fpi );
  fscanf ( fpi, "%d", &colorlevels );
  ppm_read_comments ( fpi );
  while ( ( c = getc ( fpi )) == '\n' );      //get rid of extra line returns
    ungetc ( c , fpi);

  imgBuffer = ( unsigned char *) malloc( 3 * width * height );
  if ( imgBuffer == NULL ) {
    printf("\nError in allocating memory!\n");
    return;
  }
  
  //read image up-side down
  int k;
  for ( int i = 0; i < height; i++ ) {
    k = (height - 1 - i) * width * 3;
   for ( int j = 0; j < width; j++ ) {
       imgBuffer[k++] = (unsigned char) getc( fpi );
       imgBuffer[k++] = (unsigned char) getc( fpi );
       imgBuffer[k++] = (unsigned char) getc( fpi );
    }
  }

  //read the screen data to buffer pointed by
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glRasterPos2f ( x0, y0 );
  glDrawPixels(  width, height, GL_RGB, GL_UNSIGNED_BYTE, imgBuffer);

  fclose ( fpi );
  delete imgBuffer;
}

void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();             // clear the matrix 
   glOrtho (-1.0, 1.0, -1.0, 1.0, -10.0, 10.0);
  // glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);
   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity();
  // gluLookAt ( 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   float x0 = -1.0, y0 = -1.0;
   read_ppm_image ( (char *) "../data/soolee.ppm", x0, y0);
   glColor3f (1.0, 0.8, 0.0);     
   glutSolidSphere( 0.2, 40, 40 );//draw a ball 
   glFlush ();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH );
   glutInitWindowSize (546, 506);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
