/* ppmfun.cpp
 * Compile: g++ -c ppmfun.cpp
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ppmfun.h"

using namespace std;


/*
 * Create PPM header from image width and height.  "P6" format is used.
 * PPM header returned in integer array ppmh[].
 */ 
void make_ppm_header ( int ppmh[], int width, int height )
{
  //standard header data, 'P' = 0x50, '6' = 0x36, '\n' = 0x0A
  int ca[] = {0x50, 0x36, 0x0A, 				//"P6"
	      0x33, 0x36, 0x30, 0x20, 0x32, 0x38, 0x38, 0x0A,   //image width=260, height = 288
	      0x32, 0x35, 0x35, 0x0A };				//color levels / pixel = 256

  //only have to change width and height
  char temp[10], k;

  sprintf(temp, "%3d", width );			//width in ascii code
  k = 0;
  for ( int i = 3; i <= 5; ++i )		//replace width
    ca[i] = temp[k++];

  sprintf(temp, "%3d", height );		//height in ascii code
  k = 0;
  for ( int i = 7; i <=9; ++i )			//replace height
    ca[i] = temp[k++];

  for ( int i = 0; i < 15; ++i )		//form header
    ppmh[i] = ca[i];
}

void save_ppmdata ( FILE *fp, CImage *ip, int width, int height )
{
  int size = width * height;

  for ( int i = 0; i < size; ++i ){
    putc ( ip[i].red, fp );
    putc ( ip[i].green, fp );
    putc ( ip[i].blue, fp );
  }
}

void ppm_read_comments ( FILE *fp )
{
  int c;
  while ( (c = getc ( fp ) )  == '#' ) {
    while (  getc( fp )  != '\n' )
	;
  }
  ungetc ( c, fp );
}  
