//checker.cpp
//Creating a checker board.
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>

const int width = 256, height = 256;
unsigned char board[width][height][4];

void getBoard(void)
{
   int  c;
   
   for ( int i = 0; i < width; i++ ) {
      for ( int j = 0; j < height; j++ ) {	//start from lower-left corner
         c = ((((i&16)==0)^((j&16))==0))*255; //0 or 255 --> black or white
         board[i][j][0] =  c;	//red component
         board[i][j][1] =  c;	//green component
         board[i][j][2] =  c;	//blue  component
      }
   }
}

void init(void)
{  
   glClearColor (0.8, 0.8, 1.0, 1.0);
   glShadeModel(GL_FLAT);
   getBoard();

   //Sets pixel-storage mode
   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
}
void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glRasterPos2i(0, 0);
   glDrawPixels(width, height, GL_RGBA, GL_UNSIGNED_BYTE, board);
   glFlush();
}

void reshape(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(80.0, (GLfloat) w/(GLfloat) h, 10.0, 40.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef(-12.0, -12.0, -15.0);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(300, 300);
   glutInitWindowPosition(100, 100);
   glutCreateWindow(argv[0]);
   init();
   glutDisplayFunc(display);
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0; 
}
