/*
 *  blending.cpp
 *  This program draws several overlapping filled polygons
 *  to demonstrate the effect order has on alpha blending results.
 */
#include <GL/glut.h>
#include <stdlib.h>

/*  Initialize alpha blending function.
 */
static void init(void)
{
   glEnable (GL_BLEND);
   glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
   glShadeModel (GL_FLAT);
   glClearColor (1.0, 1.0, 1.0, 1.0);
}

static void triangle( float color[4] )
{
   glColor4fv( color );
   glBegin (GL_TRIANGLES);
      glVertex3f(-2, -1.9, 0.0); 
      glVertex3f( -1, -0.9, 0.0); 
      glVertex3f( -2,  0, 0.0); 
   glEnd();
}

void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT);
   glOrtho (-2.2, 2.2, -2.2, 2.2, -2.0, 10.0);
   
    //draw red triangle first, then green
    float red[4] = { 1, 0, 0, 0.8};
    triangle( red );
    glTranslatef( 0.5, 0, 0 );
    float green[4] = { 0, 1, 0, 0.8};
    triangle( green );

    //draw green triangle first, then red
    glTranslatef( 1.2, 0, 0 );
    triangle ( green );
    glTranslatef( 0.5, 0, 0 );
    triangle ( red ); 

    glFlush();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:  /*  Escape key  */
         exit(0);
         break;
      default:
         break;
   }
}

/*  Main Loop
 *  Open window with initial window size, title bar, 
 *  RGBA display mode, and handle input events.
 */
int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGBA);
   glutInitWindowSize (400, 400);
   glutCreateWindow (argv[0]);
   init();
   glutDisplayFunc (display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
