/*
 *  perp_mat.cpp
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <iostream>
#include <malloc.h>

using namespace std;

void init(void)
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
}

//print the transformation matrix
//Use template so that we can print double, float or int
template<class T>
void print_mat ( T m[][4] )
{
  cout.precision ( 2 );
  cout << fixed;
  for ( int i = 0; i < 4; ++i ) {
    cout << "\t";
    for ( int j = 0; j < 4; ++j )
      cout <<  m[j][i] << "\t";
    cout << endl;
  }
  cout << endl;
}

template<class T>
void print_matp ( T *m )
{
  cout.precision ( 4 );
  cout << fixed;
  for ( int i = 0; i < 4; ++i ) {
    cout << "\t";
    for ( int j = 0; j < 4; ++j )
      cout <<  *(m + 4*i+j) << "\t";
    cout << endl;
  }
  cout << endl;
}

void display(void)
{
   float p[4][4];

   glClear (GL_COLOR_BUFFER_BIT);
   glMatrixMode (GL_PROJECTION);        //Current matrix is for projection
   glLoadIdentity ();             	// clear the matrix 
   glFrustum (-1.0, 1.0, -1.0, 1.0, 2.0, 10.0);
   glGetFloatv(GL_PROJECTION_MATRIX,&p[0][0]);
   cout << "NDC Perspective Projection Matrix:" << endl;
   print_mat ( p );
   gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   glGetFloatv(GL_PROJECTION_MATRIX,&p[0][0]);
   cout << "Perpective Projection Matrix:" << endl;
   print_mat ( p );
   
   glColor3f( 1, 0, 0 );
   glutWireCube( 0.4 ); 
   glFlush ();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
