/*
 * robot.cpp
 * This program shows how to composite modeling transformations
 * to draw translated and rotated hierarchical models.
 * Press 'l' or 'L' to rotate lower arm, 'u' or 'U' to rotate upper arm.
 */
#include <GL/glut.h>
#include <stdlib.h>

using namespace std;

static int angle1 = 0, angle2 = 0;

void init(void) 
{
   glClearColor (1.0, 1.0, 1.0, 1.0);
   glShadeModel (GL_FLAT);
}
  
void drawDot ( float x, float y, float z )
{ 
  glPointSize ( 6 );
  glBegin( GL_POINTS );
    glVertex3f ( x, y, z );
  glEnd();
}

void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT);

   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt ( -2.0, 2.0, 3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   glLineWidth( 3 );

   glPushMatrix();
   glColor3f(0, 0, 0);
   glTranslatef (-1.0, 0.0, 0.0);
   drawDot( 0, 0, 0 );
   glRotatef ((GLfloat) angle1, 0.0, 0.0, 1.0);
   glTranslatef (1.0, 0.0, 0.0);
   glPushMatrix();
   glScalef (2.0, 0.4, 0.5);
   glutWireCube (1.0);

   glPopMatrix();

   glTranslatef (1.0, 0.0, 0.0);
   drawDot( 0, 0, 0 );
   glRotatef ((GLfloat) angle2, 0.0, 0.0, 1.0);
   glTranslatef (1.0, 0.0, 0.0);
   glPushMatrix();
   glScalef (2.0, 0.4, 0.4);
   glutWireCube (1.0);
   glPopMatrix();
   glPopMatrix();
   glFlush();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 30.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glTranslatef (0.0, 0.0, -5.0);
}

void keyboard (unsigned char key, int x, int y)
{
   switch (key) {
      case 'U':
         angle1 = (angle1 + 5) % 360;
         glutPostRedisplay();
         break;
      case 'u':
         angle1 = (angle1 - 5) % 360;
         glutPostRedisplay();
         break;
      case 'l':
         angle2 = (angle2 + 5) % 360;
         glutPostRedisplay();
         break;
      case 'L':
         angle2 = (angle2 - 5) % 360;
         glutPostRedisplay();
         break;
      case 27:
         exit(0);
         break;
      default:
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE| GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
