#ifndef TURTLE_H
#define TURTLE_H
#include <GL/gl.h>
#include <math.h>
#include "point2.h"

class Turtle
{
public:
  Point2 cp;      //current turtle position
  float  angle;   //direction of turtle in degrees
  Turtle();       //constructor
  //move turtle to specified position
  void moveTo(float x, float y);
  void moveTo(Point2 p);
  //move certain displacement
  void moveRel(float dx, float dy);
  //draw line to specified point
  void lineTo(float x, float y);
  void lineTo(Point2 p);
  //turn to direction specified by angle
  void turnTo( float angle );  
  //turn to direction pointing from turtle position to p
  void turnTo( Point2 p );
  //turn the specified amount of angle
  void turn( float angle );
  //Move forward by dist. If isVisible != 0, a line is drawn
  //  while moving forward, otherwise no line is drawn. 
  void forward ( float dist, int isVisible );
};
#endif
