/*
 *  sine.cpp
 *  Displaying a sine curve in a world window.
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

using namespace std;

const double pi = 3.1416;

void init(void) 
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   gluOrtho2D (-pi-0.2, pi+0.2, -1.1, 1.1);
}

void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f ( 0.0, 0.0, 0.0 );   //black color
   glLineWidth ( 2 );
   double x, y, incx;
   int N = 100;
   incx = 2 * pi / N;
   //draw the sine curve
   glBegin( GL_LINE_STRIP );
     x = -pi;
     for ( int i = 0; i <= N; i++ ) {
       y = sin ( x );
       glVertex2f ( x, y );   
       x += incx;
     }
   glEnd();
   //draw the rectangle
   glBegin( GL_LINE_LOOP );
     glVertex2f(-pi, -1.0);
     glVertex2f( pi, -1.0);
     glVertex2f( pi,  1.0);
     glVertex2f(-pi,  1.0);
   glEnd();
   glFlush ();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
 //  gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 250); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
