/*
 *  lines.cpp
 *  This program demonstrates geometric primitives and
 *  their attributes.
 */
#include <GL/glut.h>
#include <stdlib.h>

using namespace std;

void init(void) 
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
}

void drawLine ( float x0, float y0, float x1, float y1 )
{
  glBegin ( GL_LINES );
     glVertex2f ( x0, y0 );
     glVertex2f ( x1, y1 );
  glEnd();
}

void display(void)
{
   int i;
   glClear (GL_COLOR_BUFFER_BIT);
   
   //draw in black
   glColor3f (0.0, 0.0, 0.0);
   glEnable (GL_LINE_STIPPLE);
  
   //1st row: 3 lines, each with a different stipple  
   glLineWidth (2.0);
   glLineStipple (1, 0x0101);  //  dotted  
   drawLine(50.0, 125.0, 150.0, 125.0);
   glLineStipple (1, 0x00FF);  //  dashed  
   drawLine (150.0, 125.0, 250.0, 125.0);
   glLineStipple (1, 0x1C47);  // dash/dot/dash  
   drawLine (250.0, 125.0, 350.0, 125.0);

   //2nd row: 3 wide lines, each with different stipple 
   glLineWidth (5.0);
   glLineStipple (1, 0x0101);  //  dotted  
   drawLine (50.0, 100.0, 150.0, 100.0);
   glLineStipple (1, 0x00FF);  //  dashed  
   drawLine (150.0, 100.0, 250.0, 100.0);
   glLineStipple (1, 0x1C47);  //  dash/dot/dash  
   drawLine (250.0, 100.0, 350.0, 100.0);
   glLineWidth (2.0);

   //3rd row: 6 lines, with dash/dot/dash stipple  
   //  as part of a single connected line strip         
   glLineStipple (1, 0x1C47);  //  dash/dot/dash  
   glBegin (GL_LINE_STRIP);
   for (i = 0; i < 7; i++)
      glVertex2f (50.0 +  i * 50.0, 75.0);
   glEnd ();
   
   glDisable (GL_LINE_STIPPLE);
   glFlush ();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
