#include <string>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Triangle.h"
#include <stdio.h>

using namespace std;
   


const string Triangle::vsCode = 
    "attribute vec4 vPosition;   \
       void main() {             \
       gl_Position = vPosition;  \
    }";
       

const string Triangle::fsCode =
     "uniform vec4 vColor;       \
      void main() {              \
        gl_FragColor = vColor;   \
      }";

const float Triangle::triangleCoords[] =
{   // in counterclockwise order:
    0.0f,  0.9f, 0.0f, // top vertex
   -0.5f, -0.3f, 0.0f, // bottom left
    0.5f, -0.2f, 0.0f  // bottom right
};

// Set color of displaying object
// with red, green, blue and alpha (opacity) values
const float Triangle::color[] = {0.89f, 0.6f, 0.4f, 1.0f};
    
// Create a Triangle object
Triangle::Triangle ( int  &success )
{
  string *vs, *fs;
  vs = (string *) &vsCode;
  fs = (string *) &fsCode;
  success = createShader ( vs, fs );
  if ( !success ) 
    printf("infoLog: %s\n", infoLog );
}

void Triangle::draw() 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");

  // Enable a handle to the triangle vertices
  glEnableVertexAttribArray( positionHandle );

  // Prepare the triangle coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, triangleCoords);

  // get handle to fragment shader's uniform variable vColor
  int colorHandle =  glGetUniformLocation(program, "vColor");
  if ( colorHandle == -1 )
    printf("No such uniform named vColor\n");

  // Set color for drawing the triangle
  glUniform4fv ( colorHandle, 1, color );

  // Draw the triangle
  glDrawArrays( GL_TRIANGLES , 0, vertexCount);
      
  // Disable vertex array
  glDisableVertexAttribArray(positionHandle);
}

