#include <string>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Shader.h"
#include <stdio.h>
#include <malloc.h>

using namespace std;

Shader::Shader()
{
  infoLog = NULL;
}   

Shader::~Shader()
{
  delete infoLog;
}
// Create a Shader object
// User provides vertex shader code (vs) and fragement shader code (fs)
bool  Shader::createShader( const string *vs, const string *fs )
{
   // create empty OpenGL   Program,load,attach,and link shaders
   program =  glCreateProgram();
   if ( vs != NULL ) {
     vertexShader = loadShader( GL_VERTEX_SHADER, vs);
     // add the vertex shader to program
     glAttachShader(program,vertexShader);
   }
   if ( fs != NULL ) {
     fragmentShader = loadShader( GL_FRAGMENT_SHADER, fs);
     // add the fragment shader to program
     glAttachShader(program,fragmentShader);
   }
   glLinkProgram(program); // creates   program executables
   int linked;
   glGetProgramiv(program, GL_LINK_STATUS, &linked);

   if (!linked) {
     printf( "Shader not linked!\n" );
     return false;
   }

   glUseProgram( program); // use shader program

   return true;
}

int Shader::loadShader (int shaderType, const string *shaderCode ) 
{

  // create a vertex shader type ( GL_VERTEX_SHADER)
  // or a fragment shader type ( GL_FRAGMENT_SHADER)
  int shader =  glCreateShader( shaderType);

  // pass source code to the shader and compile it
  char *strPointer = (char *) shaderCode->c_str();
  glShaderSource(shader, 1, &strPointer, NULL);
  glCompileShader(shader);
  int compiled;
  glGetShaderiv( shader, GL_COMPILE_STATUS, &compiled);
  if ( !compiled )
    printf("Compiling %d failed!\n", shaderType );

  int maxLength;
  glGetShaderiv( shaderType, GL_INFO_LOG_LENGTH, &maxLength);
 
  // maxLength includes NULL character
  infoLog = (char *) malloc ( sizeof( char ) * maxLength );
  glGetShaderInfoLog(vertexShader, maxLength, &maxLength, infoLog );

  return shader;
}
  
void Shader::cleanUp()
{
  glDeleteProgram ( program );
  glDeleteShader ( vertexShader );
  glDeleteShader ( fragmentShader );
} 
