#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Simpletex.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
Simpletex::Simpletex ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "simpletex.vert",  &vsSource);
  readShaderFile( (char *) "simpletex.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;
  init2DTexture();
  objType = 0;
  //anglex = angley = anglez = 0;
}

// Create checkerboad image and store image data in checkImage array
void Simpletex::makeCheckImage(void)
{
   int i, j, c;

   for (i = 0; i < iWidth; i++) {
      for (j = 0; j < iHeight; j++) {
         c = ((((i&0x8)==0)^((j&0x8))==0))*255;
         checkImage[i][j][0] = (GLubyte) c;
         checkImage[i][j][1] = (GLubyte) c;
         checkImage[i][j][2] = (GLubyte) c;
      }
   }
}

void Simpletex::init2DTexture()
{

  makeCheckImage();
  glGenTextures(1, &texName);
  glBindTexture(GL_TEXTURE_2D, texName);        //now we work on texName   
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, iWidth,
                iHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, checkImage );
  glActiveTexture(GL_TEXTURE0);
  glBindTexture(GL_TEXTURE_2D, texName);

}

void Simpletex::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int posHandle = glGetAttribLocation(program,"vPosition");
  glEnableVertexAttribArray( posHandle );

  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

   //  glutSolidSphere(), glutSolidTorus() do NOT have texture coordinates
   GLUquadric *qobj = gluNewQuadric();
   gluQuadricTexture(qobj,GL_TRUE); //requires texture coordinates
   if ( objType == 0 )
     gluSphere(qobj,0.8,32,32);
   else if ( objType == 1 ) 
     gluCylinder(qobj, 0.8, 0.8, 1.2, 32, 32);       //top, base height
   else
      glutSolidTeapot(0.6f);                         //has texture coordinates
   gluDeleteQuadric(qobj);
}

void Simpletex::setObjectType( )
{
  objType = (objType + 1 ) % 3;
}

void Simpletex::setTime ( float t )
{
  glUniform1f ( timeHandle, t );   // send the timeStep to vertex shader
}
