  // Source code of fragment shader

   varying vec3 N;
   varying vec3 L;
   varying vec3 V;
   varying vec4 lightVec;  //light vector
   varying vec4 eyeVec;    //eye vector

   uniform vec4 lightAmbient;
   uniform vec4 lightDiffuse;
   uniform vec4 lightSpecular;
   //in this example, material color same for ambient, diffuse, specular
   uniform vec4 materialColor;
   uniform float shininess;

   void main()
   {
     vec3 norm = normalize(N);
     vec3 lightv = normalize(L);
     vec3 viewv = normalize(V);
     float bumpDensity = .15;
     float bumpSize = 0.5;
     vec2 c = bumpDensity * gl_TexCoord[0].st;	
     vec2 p = fract( c ) - vec2( 0.5 );		//normal map

     float d, f;

     d = p.x * p.x + p.y * p.y;
     f = 1.0 / sqrt ( d + 1.0 );
     if ( d >= bumpSize ){
       p = vec2 ( 0.0 );
       f = 1.0;
     }


     // diffuse coefficient
     float Kd = max(0.0, dot(lightv, norm));

     // calculating specular coefficient
     // consider only specular light in same direction as normal
     float cs;
     if(dot(lightv, norm)>= 0.0) cs =1.0;
     else cs = 0.0;
     //reflection vector
     vec3 r = 2.0 *  dot (norm, lightv) * norm  - lightv;
     float Ks = pow(max(0.0, dot(r, viewv)), shininess);

     vec4 ambient = materialColor * lightAmbient;
     vec4 specular = cs * Ks * materialColor *lightSpecular;
     vec4 diffuse = Kd * materialColor *  lightDiffuse;
//-----------------------
 vec3 litColor;
  vec3 surfaceColor = vec3 ( 0.9, 0.5, 0.2 );
  vec3 normalDelta = vec3 ( p.x, p.y, 1.0 ) * f;
  float specularFactor = 0.5;
  //litColor = surfaceColor * max(dot(normalDelta, lightVec), 0.0 );
  litColor = surfaceColor * dot(normalDelta, lightVec.xyz);
  vec3 reflectVec = reflect ( lightVec.xyz, normalDelta );

  float specularLight = max ( dot(eyeVec.xyz, reflectVec), 0.0 );
  specularLight = pow ( specularLight, 6.0 ) * specularFactor;
  litColor = min ( litColor + specularLight, vec3(1.0) );

   gl_FragColor = vec4 ( litColor, 1.0 );
//-----------------------
//     gl_FragColor = ambient + diffuse + specular;
  }

