#ifndef _BUMP_H
#define _BUMP_H
#include "Shader.h"
#include <vector>

using namespace std;

class XYZ{
public:
  float x, y, z;
};

class Bump : public Shader 
{
  private:
   static const string vsCode;   // Source code of vertex shader
   static const string fsCode ;  // Source code of fragment shader
   static const int vertexCount = 3;
   static const int COORDS_PER_VERTEX = 3;
   static const int N_STACKS = 24;   
   static const int N_SLICES = 24;
   static const float shininess = 50;    
   static const float eyePos[4];	//viewing position
   static const float lightPos[4];	//light source position
   static const float lightAmbi[4];	//ambient light
   static const float lightDiff[4];	//diffuse light
   static const float lightSpec[4];	//specular light
   static const float materialColor[4];
   static const int iWidth = 64;
   static const int iHeight = 64;
   GLubyte checkImage[iHeight][iWidth][3];
   void makeCheckImage(void);

   vector<XYZ> vertices; 
   vector<XYZ> texPoints;
   // Set color with red, green, blue and alpha (opacity) values
   float *sphereCoords;
   float *texCoords;
   short *drawOrders;            //draw order list
   int nTriangles;
   unsigned texName;
   int objType;                   //Object type
  public:
   Bump( int &success );
   ~Bump();
   void createSphere ( float r, int nSlices, int nStacks ); 
   void init2DTexture();
   void draw( float mvpMatrix[4][4] );
   void setObjectType ();
   void setTime ( float t );
};
#endif

