#ifndef _SPHERES_H
#define _SPHERES_H
#include "Shader.h"
#include <vector>

using namespace std;

class XYZ{
public:
  float x, y, z;
};

class Spheres : public Shader 
{
  private:
   static const string vsCode;   // Source code of vertex shader
   static const string fsCode ;  // Source code of fragment shader
   static const int vertexCount = 3;
   static const int COORDS_PER_VERTEX = 3;
   static const int nColors = 4; // number of different colors
   static const float colors[nColors][4];
   static const int N_STACKS = 16;
   static const int N_SLICES = 24;
   vector<XYZ> vertices; 
   // Set color with red, green, blue and alpha (opacity) values
   float *sphereCoords;
   short *drawOrders;            //draw order list
   int nTriangles;

  public:
   Spheres( int &success );
   ~Spheres();
   void createSphere ( float r, int nSlices, int nStacks ); 
   void draw( float mvpMatrix[4][4] );
};
#endif

