#ifndef _SPHEREL_H
#define _SPHEREL_H
#include "Shader.h"
#include <vector>

using namespace std;

class XYZ{
public:
  float x, y, z;
};

class Spherel : public Shader 
{
  private:
   static const string vsCode;   // Source code of vertex shader
   static const string fsCode ;  // Source code of fragment shader
   static const int vertexCount = 3;
   static const int COORDS_PER_VERTEX = 3;
   static const int N_STACKS = 16;
   static const int N_SLICES = 24;
   static const float shininess = 50;    
   static const float lightPos[4];	//light source position
   static const float lightAmbi[4];	//ambient light
   static const float lightDiff[4];	//diffuse light
   static const float lightSpec[4];	//specular light
   static const float materialColor[4];
   vector<XYZ> vertices; 
   // Set color with red, green, blue and alpha (opacity) values
   float *sphereCoords;
   short *drawOrders;            //draw order list
   int nTriangles;

  public:
   static const float eyePos[4];	//viewing position
   Spherel( int &success );
   ~Spherel();                   //destructor
   void createSphere ( float r, int nSlices, int nStacks ); 
   void draw( float mvpMatrix[4][4] );
};
#endif

