// Spherel.cpp : class for rendering a lit solid sphere
#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Spherel.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
const float Spherel::eyePos[] = {0, 0, 6.3, 1};
const float Spherel::lightPos[] = {5, 10, 5, 1};
const float Spherel::lightAmbi[] = {0.1, 0.1, 0.1, 1};
const float Spherel::lightDiff[] = {1, 0.8, 0.6, 1};
const float Spherel::lightSpec[] = {0.3, 0.2, 0.1, 1};
//material same for ambient, diffuse, and specular
const float Spherel::materialColor[] = {1, 1, 1, 1};

// Create a Sphere object
Spherel::Spherel ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "spherel.vert",  &vsSource);
  readShaderFile( (char *) "spherel.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog:: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;

  createSphere (1.0f, N_SLICES, N_STACKS );
  int nVertices = vertices.size();
  int k = 0;
  int m = N_STACKS;
  int n = N_SLICES;

  // 2n(m-1) slices + 2(m-2)n stacks
  nTriangles = 2 * n * (m - 1);    //number of triangles
  drawOrders = new short[3*nTriangles];
  for ( int j = 0; j < n; j++ )
  {
     for ( int i = 0; i < m-1; i++ ) {
       short j1 = (short)(j + 1);
       if ( j == n - 1 ) j1 = 0;   //wrap around
       short ia = (short)( j * m + i ) ;
       short ib = (short)( j * m + i + 1);
       short ic = (short) (j1 * m + i );
       short id = (short)( j1 * m + i + 1 );
       drawOrders[k++] = ia;
       drawOrders[k++] = ib;
       drawOrders[k++] = ic;
   
       drawOrders[k++] = ic;
       drawOrders[k++] = ib;
       drawOrders[k++] = id;
     }
  }

  sphereCoords = new float[3*nVertices];
  k = 0;
  for ( int i = 0; i < nVertices; i++ ) {
    XYZ v = vertices[i];
    sphereCoords[k++] = v.x;
    sphereCoords[k++] = v.y;
    sphereCoords[k++] = v.z;
  }
}

Spherel::~Spherel()
{
  while (vertices.size() > 0 )
    vertices.pop_back();
}
  
void Spherel::createSphere ( float r, int nSlices, int nStacks )
{
     double phi,  theta;
     XYZ *p = new XYZ();
     const double PI = 3.1415926;
     const double TWOPI = 2 * PI;

     for ( int j = 0; j < nSlices; j++ ) {
       phi = j * TWOPI / nSlices;
       for ( int i = 0; i < nStacks; i++ ) {
         theta = i * PI / (nStacks-1);  //0 to pi
             p->x = r * (float) ( sin ( theta ) *  cos ( phi ));
         p->y = r * (float) ( sin ( theta ) *  sin ( phi ));
         p->z = r * (float)  cos ( theta );
         vertices.push_back ( *p  );
       }
     }
}

void Spherel::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");
  // Enable a handle to the sphere vertices
  glEnableVertexAttribArray( positionHandle );
  // Prepare the sphere coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, sphereCoords);
  
  // get handle to model-view projection matrix 
  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  int eyePosHandle = glGetUniformLocation(program, "eyePosition");
  int lightPosHandle = glGetUniformLocation(program, "lightPosition");
  int lightAmbiHandle = glGetUniformLocation(program, "lightAmbient");
  int lightDiffHandle = glGetUniformLocation(program, "lightDiffuse");
  int lightSpecHandle = glGetUniformLocation(program, "lightSpecular");
  int materialColorHandle = glGetUniformLocation(program, "materialColor");
  int shininessHandle =  glGetUniformLocation(program, "shininess");
  glUniform4fv(eyePosHandle, 1, eyePos);
  glUniform4fv(lightPosHandle, 1, lightPos);
  glUniform4fv(lightAmbiHandle, 1, lightAmbi);
  glUniform4fv(lightDiffHandle, 1, lightDiff);
  glUniform4fv(lightSpecHandle, 1, lightSpec);
  glUniform1f(shininessHandle, shininess);
  glUniform4fv(materialColorHandle, 1, materialColor);

  // Draw all triangles
  for ( int i = 0; i < nTriangles; i++ ) {
    int j = i % 4;    // totally only 4 different colors
   // glUniform4fv(colorHandle, 1, colors[j]);
    glDrawElements( GL_TRIANGLES, 3,
                           GL_UNSIGNED_SHORT, (drawOrders + i*3 )); 
  } 
  glDisableVertexAttribArray(positionHandle);
}

