  // spheres.vert
  attribute vec4  vPosition;
  uniform   mat4  mvpMatrix;
  uniform  float  timeLapsed;   // time in milliseconds
  void main(void)
  {
    float t1 = timeLapsed / 1000.0;  // time t1 in seconds
    vec3 d;
    
    float t = sin ( t1 );     // t varies between -1 and 1
    mat4 m = mat4( 1.0 );     // 4 x 4 identity matrix
    m = 0.2 * m;              // shrink sphere by a factor of 5
    d.x = t;                  // translation in x-direction
    d.y = t + 0.5*1.0*t*t;    // translation in y-direction
    m[3][0] = d.x;
    m[3][1] = d.y;
    m[3][3] = 1.0;            // reset last matrix element to 1 
    gl_Position =   mvpMatrix * m *  vPosition;
  }

