#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Spheres.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
// Set color of displaying object
// with red, green, blue and alpha (opacity) values
const float Spheres::color[] = { 0.9f, 0.1f, 0.9f, 1.0f }; 

  // color for each face
const float Spheres::colors[nColors][4] = {
    {1.0f, 0.0f, 0.0f, 1.0f},     // red
    {0.0f, 1.0f, 0.0f, 1.0f},     // green
    {0.0f, 0.0f, 1.0f, 1.0f},     // blue
    {1.0f, 1.0f, 0.0f, 1.0f}      // yellow
  };

    
// Create a Sphere object
Spheres::Spheres ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "spheres.vert",  &vsSource);
  readShaderFile( (char *) "spheres.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;

  createSphere (1.0f, N_SLICES, N_STACKS );
  int nVertices = vertices.size();
  int k = 0;
  int m = N_STACKS;
  int n = N_SLICES;

  // 2n(m-1) slices + 2(m-2)n stacks
  nTriangles = 2 * n * (m - 1);    //number of triangles
  drawOrders = new short[3*nTriangles];
  for ( int j = 0; j < n; j++ )
  {
     for ( int i = 0; i < m-1; i++ ) {
       short j1 = (short)(j + 1);
       if ( j == n - 1 ) j1 = 0;   //wrap around
       short ia = (short)( j * m + i ) ;
       short ib = (short)( j * m + i + 1);
       short ic = (short) (j1 * m + i );
       short id = (short)( j1 * m + i + 1 );
       drawOrders[k++] = ia;
       drawOrders[k++] = ib;
       drawOrders[k++] = ic;
   
       drawOrders[k++] = ic;
       drawOrders[k++] = ib;
       drawOrders[k++] = id;
     }
  }

  sphereCoords = new float[3*nVertices];
  k = 0;
  for ( int i = 0; i < nVertices; i++ ) {
    XYZ v = vertices[i];
    sphereCoords[k++] = v.x;
    sphereCoords[k++] = v.y;
    sphereCoords[k++] = v.z;
  }
}

Spheres::~Spheres()
{
  while (vertices.size() > 0 )
    vertices.pop_back();
}
  
void Spheres::createSphere ( float r, int nSlices, int nStacks )
{
     double phi,  theta;
     XYZ *p = new XYZ();
     const double PI = 3.1415926;
     const double TWOPI = 2 * PI;

     for ( int j = 0; j < nSlices; j++ ) {
       phi = j * TWOPI / nSlices;
       for ( int i = 0; i < nStacks; i++ ) {
         theta = i * PI / (nStacks-1);  //0 to pi
             p->x = r * (float) ( sin ( theta ) *  cos ( phi ));
         p->y = r * (float) ( sin ( theta ) *  sin ( phi ));
         p->z = r * (float)  cos ( theta );
         vertices.push_back ( *p  );
       }
     }
}

void Spheres::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");
  // Enable a handle to the sphere vertices
  glEnableVertexAttribArray( positionHandle );
    // Prepare the sphere coordinate data
    glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, sphereCoords);

  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  // get handle to fragment shader's uniform variable vColor
  int colorHandle =  glGetUniformLocation(program, "vColor");
  if ( colorHandle == -1 )
    printf("No such uniform named vColor\n");
  timeHandle =  glGetUniformLocation(program, "timeLapsed");
  if ( timeHandle == -1 )
    printf("No such uniform named timeLapsed\n");


  for ( int i = 0; i < nTriangles; i++ ) {
    int j = i % 4;
    glUniform4fv(colorHandle, 1, colors[j]);
    
    glDrawElements( GL_TRIANGLES, 3,
                           GL_UNSIGNED_SHORT, (drawOrders + i*3 )); 
  } 
  glDisableVertexAttribArray(positionHandle);
}

void Spheres::setTime ( float t )
{
  glUniform1f ( timeHandle, t );   // send the lapsed time to vertex shader
}
