  // particles.vert : vertex shader
  attribute vec4  vPosition;
  uniform   mat4  mvpMatrix;
  uniform  float  timeLapsed;   // time in milliseconds
  void main(void)
  {
    float t = timeLapsed / 5000.0;  // adjust time
    float s = sin ( t );      // s varies between -1 and 1
    mat4 m = mat4( 1.0 );     // 4 x 4 identity matrix
    m = s * m;                // try to create scale matrix
    m[3][3] = 1.0;            // set last matrix element to 1 to form a proper scale matrix
    gl_Position = m * mvpMatrix * vPosition;
  }

