/*  cube.cpp
 *  Drawing two colored cubes using glDrawElements().
 */

#include <GL/glut.h>
#include <stdlib.h>

void init(void) 
{
   glClearColor (0.0, 0.0, 0.0, 0.0);
   glShadeModel (GL_SMOOTH);

   // Enable using vertex array
   glEnableClientState (GL_VERTEX_ARRAY);
   glEnableClientState (GL_COLOR_ARRAY);
}

void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (1.0, 1.0, 1.0);
   glLoadIdentity ();             /* clear the matrix */
   // Look at cube from the front
   gluLookAt (0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

   GLint vertices[] = {-1, -1, -1,   // vertex 0
                        1, -1, -1,   // vertex 1
                        1,  1, -1,   // 2
                       -1,  1, -1,   // 3
		       -1, -1,  1,   // 4
			1, -1,  1,   // 5
			1,  1,  1,   // 6
		       -1,  1,  1};  // 7
                       
   GLfloat colors[] = {1.0, 0.2, 0.2, // RGB color for vertex 0
                       0.2, 0.2, 1.0, // 1
                       0.8, 1.0, 0.2, // 2
                       0.7, 0.7, 0.7, // 3
                       0.3, 0.3, 0.3, // 4
                       0.5, 0.5, 0.5, // 5
		       1.0, 0.0, 0.0, // 6 
			0.0, 1.0, 0.0 // 7
			};
   
   // point to the vertex and color data of cube
   glVertexPointer (3, GL_INT, 0, vertices);
   glColorPointer (3, GL_FLOAT, 0, colors);

   // Do not display back face
   glEnable( GL_CULL_FACE );
   glCullFace ( GL_BACK );
   // Display cube on lower left of screen, rotate it for 3D view
   glRotatef ( 30, 1, 1, 1 );
   glTranslatef ( -0.6, -0.6, 0 );
   // uncomment this to test glArrayElement
/*
   glBegin( GL_QUADS );
     glArrayElement ( 4 );    // front face (see notes)
     glArrayElement ( 5 );
     glArrayElement ( 6 );
     glArrayElement ( 7 );

     glArrayElement ( 0 );   // back face
     glArrayElement ( 3 );
     glArrayElement ( 2 );
     glArrayElement ( 1 );
     
     glArrayElement ( 1 );   // right
     glArrayElement ( 2 );
     glArrayElement ( 6 );
     glArrayElement ( 5 );
     
     glArrayElement ( 0 );   // left
     glArrayElement ( 4 );
     glArrayElement ( 7 );
     glArrayElement ( 3 );

     glArrayElement ( 2 );   // top
     glArrayElement ( 3 );
     glArrayElement ( 7 );
     glArrayElement ( 6 );

     glArrayElement ( 0 );   // bottom
     glArrayElement ( 1 );
     glArrayElement ( 5 );
     glArrayElement ( 4 );
   glEnd();
*/
  // define vertex indices of each face of the cube 
  GLubyte frontIndices[] = {4, 5, 6, 7};
  GLubyte backIndices[]  = {0, 3, 2, 1};
  GLubyte rightIndices[] = {1, 2, 6, 5};
  GLubyte leftIndices[]  = {0, 4, 7, 3};
  GLubyte topIndices[]   = {2, 3, 7, 6};
  GLubyte bottomIndices[]= {0, 1, 5, 4};
  // draw the cube
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, frontIndices);
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, rightIndices);
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, bottomIndices);
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, backIndices);
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, leftIndices);
  glDrawElements(GL_QUADS, 4, GL_UNSIGNED_BYTE, topIndices);

  // put vertex indices of all faces in one array
  GLubyte allIndices[] = {4, 5, 6, 7, 0, 3, 2, 1, 1, 2, 6, 5,  
                          0, 4, 7, 3,  2, 3, 7, 6, 0, 1, 5, 4};
  // Draw another queue at upper right of screen
  glTranslatef ( 1.2, 1.2, 0 );
  glDrawElements(GL_QUADS, 24, GL_UNSIGNED_BYTE, allIndices);
  glFlush ();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);
   glMatrixMode (GL_MODELVIEW);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
