#include "XYZ.h"

XYZ::XYZ()
{
  x = y = z = 0;
}

XYZ::XYZ( double x0, double y0, double z0 )
{
  x = x0;  y = y0;  z = z0;
}

XYZ::XYZ( double a[] )
{
  x = a[0];  y = a[1];  z = a[2];
}

void XYZ::set( double x0, double y0, double z0 )
{
  x = x0;  y = y0;  z = z0;
}

void XYZ::set( double a[] )
{
  set ( a[0], a[1], a[2] );
}
/*
XYZ &XYZ::getXYZ( XYZ &xyz )
{
  xyz.set ( x, y, z );
  
  return xyz;
}
*/

XYZ XYZ::getXYZ()
{
  XYZ a( x, y, z );
  
  return a;
}

void XYZ::getXYZ( double a[] )
{
  a[0] = x;
  a[1] = y;
  a[2] = z;
}

void XYZ::add ( const XYZ &a,  const XYZ &b, double sum[] )
{
  sum[0] = a.x + b.x;
  sum[1] = a.y + b.y;
  sum[2] = a.z + b.z;
}

void XYZ::subtract ( const XYZ &a,  const XYZ &b, double diff[] )
{
  diff[0] = a.x - b.x;
  diff[1] = a.y - b.y;
  diff[2] = a.z - b.z;
}

void XYZ::print()
{
  cout << "(" << x <<", " << y << ", " << z << ")" << endl;
}

ostream& operator<< ( ostream& os, const XYZ& u )
{
    return (os << "(" << u.x << "," << u.y << "," << u.z << ")");
}


bool operator == ( const XYZ &a1, const XYZ &a2 )
{
  if ( a1.x != a2.x || a1.y != a2.y || a1.z != a2.z )
    return false;

  return true;
}


