/*
  ray.h
*/
#ifndef RAY_H
#define RAY_H

#include <vector>
#include "Point3.h"
#include "Vector3.h"

using namespace std;

class Ray {
public:
  Point3  O;	//starting point (origin)
  Vector3 D;	//direction vector
  //Ray () : origin( Point3(0, 0, 0), direction( Vector3( 0, 1, 0 ) ) {}
  Ray()			//default constructor
  {
    O = Point3( 0.0, 0.0, 0.0 );
    D = Vector3( 1.0, 1.0, 1.0 );
    D.normalize();
  }
  //constructor
  Ray ( const Point3 &origin, const Vector3 &dir ){
    O = origin;
    D = dir;
    D.normalize();
  }
  //return point L(t) at t 
  Point3 getPoint ( const double t )
  {
    return O +  t * D;
  }  
};

#endif
