/*
  Box.h
  Note: Box specified by minimum and maximum extents.
        Assume box faces parallel to X, Y, Z planes.
*/
#ifndef BOX_H
#define BOX_H

#include "Vector3.h"
#include "Point3.h"
#include <math.h>
#include <assert.h>

using namespace std;

class Box {
public:
  Point3 pl;            //minimum extent
  Point3 ph;            //maximum extent
  Box (){		//default box center at origin
    pl = Point3( -1, -1, -1 );
    ph = Point3( 1, 1, 1 );
  }
  Box ( const Point3 &p1,  const Point3 &p2 )
  {
    assert ( p1.x < p2.x && p1.y < p2.y && p1.z < p2.z );
    pl = p1;
    ph = p2;
  }
};

#endif
