/*
 * Camera.h
 */
#ifndef CAMERA_H
#define CAMERA_H
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <GL/glut.h>
#include "Point3.h"
#include "Vector3.h"

using namespace std;

class Camera {
public:
   Point3 p;            // View position          
   Point3 focus;        // Point at which camera focuses
   Vector3   v;         // View direction vector   
   Vector3  up;         // View up direction      
   double f;            // Focal Length along v
   double fov;          // Camera aperture (field of view)         
   double es;           // Eye separation   
   int    w;            // Viewplane width
   int    h;            // Viewplane height       

   //constructor
   Camera ();
   void setCamera ( double f0, double es0, double fov0, int w0, int h0 );
   void lookAt ();
   void lookAt ( const Point3 &eyePos, const Point3 &focus, const Vector3 &up0 );
};
#endif
