/*
 * Camera.cpp
 */

#include "Camera.h"

using namespace std;

Camera::Camera ()
{
      // default parameters
      f = 10.0;
      es = f / 30;
      fov = 60;
      w = 800;
      h = 600;
      p = Point3 ( 0, 0, -10 );  //viewpoint
      focus = Point3( 0, 0, 0); //focus
      v = Vector3 ( 0, 0, 1 );     //view direction
      up = Vector3 ( 0, 1, 0 );    //up vector
}

void Camera::setCamera ( double f0, double es0, double fov0, int w0, int h0 )
{
     f  = f0;
     es = es0;
     fov = fov0;
     w  = w0;
     h  = h0;
}

void Camera::lookAt ()
{
     gluLookAt( p.x, p.y, p.z, focus.x, focus.y, focus.z, up.x, up.y, up.z );
}

void Camera::lookAt ( const Point3 &eyePos, const Point3 &focus, const Vector3 &up0 )
{
     p = eyePos;
     up = up0;
     gluLookAt( p.x, p.y, p.z, focus.x, focus.y, focus.z, up.x, up.y, up.z );
}

