/*   subdivision.cpp
 *   Use subdivision to create 80-sided spherical approximation
 *   Fore June
 */

#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "Point3.h"
#include "Vector3.h"


const double X = .525731112119133606;
const double Z = .850650808352039932;

static double vdata[12][3] = {    
   {-X, 0.0, Z}, {X, 0.0, Z}, {-X, 0.0, -Z}, {X, 0.0, -Z},    
   {0.0, Z, X}, {0.0, Z, -X}, {0.0, -Z, X}, {0.0, -Z, -X},    
   {Z, X, 0.0}, {-Z, X, 0.0}, {Z, -X, 0.0}, {-Z, -X, 0.0} 
};
//indices for triangles
static int tindices[20][3] = { 
   {0,4,1}, {0,9,4}, {9,5,4}, {4,5,8}, {4,8,1},    
   {8,10,1}, {8,3,10}, {5,3,8}, {5,2,3}, {2,7,3},    
   {7,10,3}, {7,6,10}, {7,11,6}, {11,0,6}, {0,1,6}, 
   {6,1,10}, {9,0,11}, {9,11,2}, {9,2,5}, {7,2,11} };

Point3 vertices[12];

void midPoint ( const Point3 &p1, const Point3 &p2,  Point3  &p12 )
{
  p12.x = ( p1.x + p2.x ) / 2.0;
  p12.y = ( p1.y + p2.y ) / 2.0;
  p12.z = ( p1.z + p2.z ) / 2.0;
}

void triangle ( const Point3 &p1, const Point3 &p2, const Point3 &p3 ) 
{ 
   glBegin(GL_TRIANGLES); 
      glNormal3f( p1.x, p1.y, p1.z ); glVertex3f( p1.x, p1.y, p1.z );    
      glNormal3f( p2.x, p2.y, p2.z ); glVertex3f( p2.x, p2.y, p2.z );    
      glNormal3f( p3.x, p3.y, p3.z ); glVertex3f( p3.x, p3.y, p3.z );    
   glEnd(); 
}

void subdivide( const Point3 &p1, const Point3 &p2, const Point3 &p3) 
{ 
   Point3 p12, p23, p31;    

   midPoint ( p1, p2, p12 );
   midPoint ( p2, p3, p23 );
   midPoint ( p3, p1, p31 );

   Point3 O (0, 0, 0);		//sphere center
   Vector3 v12, v23, v31;	//3D vectors
   v12 = p12 - O;
   v23 = p23 - O;
   v31 = p31 - O;
   //normalize the vectors
   v12.normalize();
   v23.normalize();
   v31.normalize();
   //find vertices at vector tips
   p12 = v12 + O;
   p23 = v23 + O;
   p31 = v31 + O;
   triangle ( p1, p12, p31 );
   triangle ( p2, p23, p12 );
   triangle ( p3, p31, p23);    
   triangle ( p12, p23, p31); 
}


void init(void) 
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
   for ( int i = 0; i < 12; i++ )
     vertices[i] = Point3 ( vdata[i]  );
}


void display(void)
{
   glClear (GL_COLOR_BUFFER_BIT);
   glLineWidth ( 2 );
   glColor3f (0.0, 0.0, 0.0);
   glLoadIdentity ();            
   gluLookAt (2.2, 2.2, 2.2, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
  
  glPolygonMode( GL_FRONT_AND_BACK, GL_LINE ); 
  for (int i = 0; i < 20; i++) { 
    int i0 = tindices[i][0];
    int i1 = tindices[i][1];
    int i2 = tindices[i][2];
    subdivide( vertices[i0], vertices[i1], vertices[i2] );
  }
  glFlush ();
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h); 
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 10.0);
   glMatrixMode (GL_MODELVIEW);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
