/*   bezsurface.cpp
 **  This program uses evaluators to draw a Bezier surface.
 **/
#include <GL/glut.h>
#include <stdlib.h>

const int uOrder = 4;                                                                  
const int vOrder = 4;
                                                                                
float controlPoints[uOrder][vOrder][3] = {
   {{-2, -1, 4.0}, {-1, -1, 3.0},
    {0, -1, -1.5}, {2, -1, 2.5}},
   {{-2, -0.5, 1.0}, {-1, -0.5, 3.0},
    {0, -0.5, 0.0}, {2, -0.5, -1.0}},
   {{-2, 0.5, 4.0}, {-1, 0.5, 1.0},
    {0, 0.5, 2.0}, {2, 0.5, 4.0}},
   {{-2, 1.5, -2.0}, {-1, 1.5, -2.0},
    {0, 1.5, 0.0}, {2, 1.5, -1.0}}
};
                                                                               
void init(void)
{
   glClearColor(1.0, 1.0, 1.0, 0.0);
   glMap2f(GL_MAP2_VERTEX_3, 0, 1, 3, uOrder,
           0, 1, 12, vOrder, &controlPoints[0][0][0]);
   glEnable(GL_MAP2_VERTEX_3);
   glMapGrid2f(20, 0.0, 1.0, 20, 0.0, 1.0);
   glEnable(GL_DEPTH_TEST);
}
                                                                                
void display(void)
{
   int i, j;
   float u, v;
                                                                                
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glColor3f( 0.0, 0.0, 0.0 );
   gluLookAt ( 10, 10, 10, 0, 0.0, 0.0, 0.0, 1.0, 0.0);
   glEnable ( GL_LINE_SMOOTH );
   glLineWidth( 2 ); 

   const int n1 = 8, n2 = 30;
   for ( i = 0; i <= n1; i++ ) { 
      v = (float) i / n1;
      glBegin(GL_LINE_STRIP);
      for (j = 0; j <= n2; j++){
	 u = (float) j / n2;
         glEvalCoord2f( u, v );
      }
      glEnd();
   }
   for (i = 0; i <= n1; i++) {
      u = (float) i / n1;
      glBegin(GL_LINE_STRIP);
      for (j = 0; j <= n2; j++) {
	 v = (float) j / n2;
         glEvalCoord2f( u, v );
      }
      glEnd();
   }
/*
   // The following code displays the control points as dots. 
   glPointSize( 6.0 );
   glColor3f( 1.0, 0.0, 0.0 );
   glEnable ( GL_POINT_SMOOTH );
   glBegin(GL_POINTS);
      for ( i = 0; i < uOrder; i++ )
	for ( j = 0; j < vOrder; j++ )
         glVertex3fv( &controlPoints[i][j][0] );
   glEnd();
*/
   glFlush();
}
 
void reshape(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho(-5.0, 5.0, -5.0*(float)h/(float)w,
               5.0*(float)h/(float)w, 5.0, 25.0);
   else
      glOrtho(-5.0*(float)w/(float)h,
               5.0*(float)w/(float)h, -5.0, 5.0, 5.0, 25.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}
                                                                                
void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}
                                                                                
int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutReshapeFunc(reshape);
   glutKeyboardFunc (keyboard);
   glutMainLoop();
   return 0;
}
