/**
 * treexml.cpp
 * Adopted from the program "tree1.c" of libxml2.
 * It parses a file to a tree, using xmlDocGetRootElement() to
 *   get the root element. It then scans the document and prints
 *   all the element names in document order along with a number 
 *   of +'s to represent the node level. 
 *  Most likely, your system already has libxml2 installed.
 *  If not, download it from http://xmlsoft.org and install it.
 */
#include <stdio.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlreader.h>


/**
 * print_element_names:
 * @root: the initial xml node to consider.
 *
 * Prints the names of the all the xml elements
 * that are siblings or children of a given xml node.
 * The number of +'s represents the level of the node.
 */
void print_element_names(xmlNode *root, int level )
{
    xmlNode *cur_node = NULL;
    ++level;   //one level deeper in next call
    
    for (cur_node = root; cur_node; cur_node = cur_node->next) {
        if (cur_node->type == XML_ELEMENT_NODE) {
    	  for ( int i = 0; i < level; i++ )
      	    printf(" +");  //signifies level of node
          printf(" %s\n", cur_node->name);
        } 
        print_element_names( cur_node->children, level );
    }
}

/**
 * Simple example to parse a file called "cube.dae"
 * walk down the DOM, and print the name of the 
 * xml elements nodes.
 */
int main()
{
    xmlDoc *doc = NULL;
    xmlNode *root = NULL;
    const char filename[] = "cube.dae";

    // Initialize library and check whether correct version is used.
    LIBXML_TEST_VERSION
    // parse the file and get the DOM 
    doc = xmlReadFile( filename, NULL, 0);

    if ( doc == NULL ) {
        printf( "error: could not parse file %s\n", filename );
	return 1;
    }

    // Get the root element node 
    root = xmlDocGetRootElement( doc );

    //starts printing from the root at level -1 
    print_element_names( root, -1 ); 

    xmlFreeDoc(doc);

    /*
     * Free the global variables that may
     * have been allocated by the parser.
     */
    xmlCleanupParser();

    return 0;
}
