/*
 * toein.cpp
 * Demonstration of using toe-in method to create anaglyph
 * Fore June
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

using namespace std;
void drawScene(void);

class Point3{
public:
  double x, y, z;

  Point3()
  { x = y = z = 0; }

  Point3 ( double x0, double y0, double z0 )
  {
    x = x0;  y = y0;  z = z0;
  } 

  Point3 ( const Point3 &p )
  {
    x = p.x;    y = p.y;   z = p.z;
  } 
};

class Vector3{
public:
  double x, y, z;

  Vector3()
  { x = y = z = 0; }

  Vector3 ( double x0, double y0, double z0 )
  {
    x = x0;  y = y0;  z = z0;
  }

  Vector3 ( const Vector3 &v )
  {
    x = v.x;    y = v.y;    z = v.z;
  }  
};

class Camera {
public:
   Point3 p;		// View position          
   Point3 focus;        // Point at which camera focuses
   Vector3   v;            // View direction vector   
   Vector3  up;            // View up direction      
   double f;            // Focal Length along v
   double fov;          // Camera aperture (field of view)         
   double es;           // Eye separation   
   int    w;            // Viewplane width
   int    h;            // Viewplane height       

   //constructors
   Camera ()
   {
      // default parameters
      f = 10.0;
      es = f / 30;
      fov = 60;
      w = 400;
      h = 300;
      p = Point3 ( 0, 0, 10 );  //viewpoint
      focus = Point3( 0, 0, 0); //focus
      v = Vector3 ( 0, 0, 1 );     //view direction
      up = Vector3 ( 0, 1, 0 );    //up vector
   }

   void setCamera ( double f0, double es0, double fov0, int w0, int h0 )
   {
     f  = f0;
     es = es0;
     fov = fov0;
     w  = w0;
     h  = h0;
   }

   void lookAt ()
   {
     gluLookAt( p.x, p.y, p.z, focus.x, focus.y, focus.z, up.x, up.y, up.z );
     //printf("(%f, %f, %f) (%f, %f, %f) (%f, %f, %f) \n", 
     // 	p.x, p.y, p.z, focus.x, focus.y, focus.z, up.x, up.y, up.z );
   }
  
   void lookAt ( const Point3 &eyePos, const Point3 &focus, const Vector3 &up0 )
   {
     p = eyePos;
     up = up0;
     gluLookAt( p.x, p.y, p.z, focus.x, focus.y, focus.z, up.x, up.y, up.z );
   }
};

Camera camera;

void init(void)
{
   glEnable(GL_DEPTH_TEST);
   glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
   glFrontFace(GL_CW);
   glClearColor ( 0, 0, 0, 0.0 );     //black background
   glClearAccum ( 0.0, 0.0, 0.0, 0.0 );   

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   //setup camera
   double focalLength = 15;
   double eyeSeparation = focalLength / 30.0;
   double fov = 60;
   camera.setCamera ( focalLength, eyeSeparation, fov, 400, 300 );
   Point3 focus ( 0, 0, 0 );
   Vector3 up ( 0, 1,  0 );
   camera.focus = focus;
   camera.up = up;
   double aspectRatio = (double) camera.w / camera.h;
   gluPerspective( camera.fov, aspectRatio, 0.1, 10000.0 );
}

void display(void)
{
   // Set the buffer for writing and reading 
   glDrawBuffer(GL_BACK);
   glReadBuffer(GL_BACK);

   // Clear things 
   glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
   glClear ( GL_ACCUM_BUFFER_BIT ); 
   // Left eye  projection
   glMatrixMode(GL_MODELVIEW);
   glDrawBuffer(GL_BACK_RIGHT);
   glLoadIdentity();
   // setup camera for left eye
   double d = 10;
   Point3 viewPoint ( -camera.es / 2, 0, d );
   camera.p = viewPoint;		//change camera viewpoint
   camera.lookAt();

   // Left eye filter
   glColorMask(GL_TRUE,GL_FALSE,GL_FALSE,GL_TRUE);
 
   drawScene();
   // Write over the accumulation buffer 
   glAccum( GL_LOAD, 1.0 ); 
   glDrawBuffer(GL_BACK);
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   //right side projection
   glMatrixMode(GL_MODELVIEW);
   glDrawBuffer(GL_BACK_LEFT);
   glLoadIdentity();
   viewPoint.x = camera.es / 2;
   camera.p = viewPoint;		//change camera viewpoint
   camera.lookAt();
   // Right eye filter 
   glColorMask(GL_FALSE,GL_FALSE,GL_TRUE,GL_TRUE);
   drawScene();
   glFlush();
   // Addin the new image and copy the result back 
   glAccum(GL_ACCUM, 1.0);

   // Allow all colors
   glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);

   glAccum(GL_RETURN,1.0);
   glutSwapBuffers();
}

/*
   Create the scene 
*/
void drawScene(void)
{
  glPushMatrix();
  glRotatef ( 20, 1, 0, 0 );
  glRotatef ( 45, 0, 1, 0 );
  glLineWidth ( 3 );
  glutWireCube( 4 );
  glPopMatrix();
  glPushMatrix();
  glTranslatef ( 1, 0, 4 );
  glRotatef ( 25, 0, 1, 0 );
  glutSolidTeapot ( 1 );
  glPopMatrix();
}

void keyboard(unsigned char key,int x, int y)
{
   switch (key) {
   case 27:             //ESC
      exit(0); 
   }
}

int main(int argc,char **argv)
{
   glutInit(&argc,argv);
   glutInitDisplayMode(GLUT_DOUBLE | GLUT_ACCUM | GLUT_RGB | GLUT_DEPTH);

   glutCreateWindow("Toein Anaglyph Demo");
   glutReshapeWindow( 400, 300 );
   glutInitWindowPosition(100, 100);

   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   init();
   glutMainLoop();
   return(0);
}

