package opengl.es10;

import java.nio.ByteBuffer;

import java.nio.ByteOrder;

import java.nio.FloatBuffer;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.opengl.GLSurfaceView;
import android.opengl.GLU;

public class HelloESRenderer implements GLSurfaceView.Renderer {
	
	private FloatBuffer triangle;
	
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        // Set the background frame color to blue
        gl.glClearColor(0.0f, 0.0f, 0.9f, 1.0f);
        // initialize the triangle vertex array
        initShapes();
        // Enable use of vertex arrays
        gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);
    }
    
    public void onDrawFrame(GL10 gl) {
        // Redraw background color
        gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);
        // Set GL_MODELVIEW transformation mode
        gl.glMatrixMode(GL10.GL_MODELVIEW);
        gl.glLoadIdentity();   // reset the matrix to its default state
        
        // When using GL_MODELVIEW, you must set the view point
        // camera at (0, 0, 5) look at (0,0,0), up - (0, 1, 0)
        GLU.gluLookAt(gl, 0, 0, 5, 0f, 0f, 0f, 0f, 1.0f, 0.0f);
        //rotate about z-axis for 30 degrees
        gl.glRotatef(30, 0, 0, 1);
        //magnify triangle by x3 in y-direction
        gl.glScalef ( 1, 3, 1);
        // Draw the triangle
        gl.glColor4f(0.0f, 1.0f, 0.0f, 0.0f);
        gl.glVertexPointer(3, GL10.GL_FLOAT, 0, triangle);
        gl.glDrawArrays(GL10.GL_TRIANGLES, 0, 3);
    }
    
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        gl.glViewport(0, 0, width, height);
        // make adjustments for aspect ratio of screen 
        float aratio = (float) width / height;
        //left, right, bottom, top, near, far
        float l, r, b, t, n, f;
        b = -1.5f; t = 1.5f; n = 3.0f; f = 7.0f;
        l =  b * aratio; r = t * aratio;
        
        gl.glMatrixMode(GL10.GL_PROJECTION);        // set matrix to projection mode
        gl.glLoadIdentity();                        // reset the matrix to its default state
        gl.glFrustumf( l, r, b, t, n, f);  // apply the projection matrix
    }
    
    private void initShapes(){        
        float vertices[] = {
            // (x, y, z) of triangle
            -0.6f, -0.5f, 0,
             0.6f, -0.5f, 0,
             0.0f,  0.5f, 0
        }; 
        
        // initialize vertex Buffer for triangle  
        ByteBuffer vbb = ByteBuffer.allocateDirect(
                // (# of coordinate values * 4 bytes per float)
                vertices.length * 4); 
        vbb.order(ByteOrder.nativeOrder());// use the device hardware's native byte order
        triangle = vbb.asFloatBuffer();  // create a floating point buffer from the ByteBuffer
        triangle.put(vertices);    // add the coordinates to the FloatBuffer
        triangle.position(0);            // set the buffer to read the first coordinate    
    }
}