/*
 * teapot-ppm.cpp
 * Demonstration of creating graphics images using OpenGL and saving them
 * in PPM format.
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <iostream>
#include "ppmfun.h"

using namespace std;

GLfloat diffuseMaterial[4] = { 0.5, 0.5, 0.5, 1.0 };

void init(void)
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat light_position[] = { 1.0, 1.0, 1.0, 0.0 };

   glShadeModel (GL_SMOOTH);
   glEnable(GL_DEPTH_TEST);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

   glColorMaterial(GL_FRONT, GL_DIFFUSE);
   glEnable(GL_COLOR_MATERIAL);

}
  
void save_ppmRGB ( FILE *fp, unsigned char *p, int width, int height )
{
  //save data up-side-down 
  int k;
  for ( int i = 0; i < height; i++ ) {
    k = (height - 1 - i) * width * 3;
   for ( int j = 0; j < width; j++ ) {
       putc( p[k++], fp );
       putc( p[k++], fp );
       putc( p[k++], fp );
    }
  }   
}
 
void ppm_save_image ( char *n1, int x0, int y0, int width, int height )
{
  unsigned char *imgBuffer;
  imgBuffer = ( unsigned char *) malloc( 3 * width * height );
  if ( imgBuffer == NULL ) {
    printf("\nError in allocating memory!\n");
    return;
  }
  //read the screen data to buffer pointed by imgBuffer
  glPixelStorei(GL_PACK_ALIGNMENT, 1);
  glReadPixels( x0, y0, width, height, GL_RGB, GL_UNSIGNED_BYTE, imgBuffer);

  int ppmh[20], c;     //PPM header
  make_ppm_header ( ppmh, width, height );
  FILE *fpo = fopen ( n1, "wb" );
  if ( fpo == NULL ) {
    printf("\nError opening file %s!\n", n1);
    delete imgBuffer;
    return;
  }
  for ( int i = 0; i < 15; ++i )                //save PPM header
    putc ( ppmh[i], fpo );
  save_ppmRGB ( fpo, imgBuffer, width, height );
  fclose ( fpo );
  delete imgBuffer;
}

void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();             // clear the matrix 
   glFrustum (-1.0, 1.0, -1.0, 1.0, 1.5, 20.0);
   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt ( 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   glColor3f (1.0, 0.0, 0.0);     //red color
   glutSolidTeapot( 0.6 );        //draw a teapot
   glColor3f (0.0, 1.0, 0.0);     //green color
   glTranslatef(-0.5, -0.5, -1.0); 
   glutSolidSphere( 0.6, 40, 40 );//draw a sphere
   glFlush ();
   int x0 = 140, y0 = 160, width = 200, height = 150;
   ppm_save_image ( "teapot.ppm", x0, y0, width, height );  
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH );
   glutInitWindowSize (500, 500);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
