/*
 * planet.cpp
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <iostream>
#include <SDL/SDL.h>

using namespace std;

float  anglePlanet = 0, angleMoon = 0,  angleSat = 0;          //rotation angles
bool   pausing = false;


void init(void)
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_SMOOTH );
   glLoadIdentity ();             	// clear the matrix 
   glMatrixMode (GL_PROJECTION);
           				// viewing transformation  
   glFrustum (-3, 3, -3, 3, 1.5, 200.0);

   glMatrixMode (GL_MODELVIEW);
   glLoadIdentity ();             	// clear the matrix 
   gluLookAt ( 0, 1, 8.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat diffuseMaterial[4] = { 0, 0.5, 0.5, 1.0 };
   GLfloat light_position[] = { 0, 0, 1, 0.0 };
   GLfloat light_position1[] = { 0, 0, 0, 1.0 };
   GLfloat light1[] = {1, 1, 1 };

   glShadeModel (GL_SMOOTH);
   glEnable(GL_DEPTH_TEST);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuseMaterial);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialf(GL_FRONT, GL_SHININESS, 25.0);
   glLightfv(GL_LIGHT1, GL_DIFFUSE, light1 );
   glLightfv(GL_LIGHT1, GL_AMBIENT, light1 );
   glLightfv(GL_LIGHT1, GL_SPECULAR, light1 );
   glLightfv(GL_LIGHT1, GL_POSITION, light_position1);
   //uncomment this following line for lighting effect
   //   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

   glColorMaterial(GL_FRONT, GL_DIFFUSE);
   glEnable(GL_COLOR_MATERIAL);

}

void satellite()
{  
   glPushMatrix();
   glColor3f ( 0.1, 1, 0.1 );
   glRotatef ( angleSat, 0, 1, 0 );  
   glTranslatef ( 0.5, 0.0, 0 );  
   glutSolidSphere( 0.1, 32, 24 );
   glPopMatrix();
}

void moon()
{ 
   glColor3f ( 1, 1, 0 );  //yellow
   glPushMatrix();
   glRotatef ( angleMoon, 0, 0, 1 );  
   glTranslatef ( 1, 0.0, 0 );  
   glutSolidSphere( 0.2, 32, 24 );
   satellite();  //satellite revolving around moon
   glPopMatrix();
}

// r is radius of planet, d is distance from the sun
void planet( float r, float d, int n )
{
   float angle = anglePlanet / d; 
   glPushMatrix();
   glDisable (GL_LIGHT0);
   glEnable (GL_LIGHT1);
   glColor3f (0.6, 0.4, 0.5);   
   glRotatef ( angle, 0, 1, 0 );  
   glTranslatef ( d, 0.0, 0 );  
   glutSolidSphere( r, 32, 24 );
   if ( n == 2 )
      moon();     //moon revolving around outermost planet
   glDisable (GL_LIGHT1);
   glEnable (GL_LIGHT0);
   glPopMatrix();
}


void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   
   glColor3f (1.0, 0.0, 0.0);     // red color
   glutSolidSphere( 1.5, 32, 24 );// the sun

   planet( 0.5, 2, 0 );  //planets revolving around sun
   planet( 0.8, 4, 1 );
   planet( 0.4, 6, 2 );
   glFlush ();
   glutSwapBuffers();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
      case 'p':
	 pausing = true;
         break;
      case 'r':
	 pausing = false;
	 break;
   }
}

void animate()
{
  anglePlanet += 2;
  angleMoon += 6;
  angleSat += 8;
  glutPostRedisplay ();
}

void idle ()
{
   static unsigned int prev_time = SDL_GetTicks(),
      current_time = SDL_GetTicks();

   current_time = SDL_GetTicks();          //ms since library starts
   int diff = current_time - prev_time;
   if ( diff < 200 ){    //5 fps ~ 200 ms / frame
      int delay = 200 - ( current_time - prev_time );
       SDL_Delay ( delay );
   }
   prev_time = current_time;
   if ( !pausing )
     animate();
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE| GLUT_RGB | GLUT_DEPTH );
   glutInitWindowSize (500, 500);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutIdleFunc ( idle );
   glutMainLoop();
   return 0;
}
