//turtle.cpp
#include <stdio.h>
#include <stdlib.h>
#include "turtle.h"

//default constructor
Turtle::Turtle()
{
  cp.set ( 0, 0 );
  angle = 0;
}

//changes current position
void Turtle::moveTo(float x, float y)
{
  cp.set(x, y);
}

void Turtle::moveTo(Point2 p)
{
  cp.set(p.x, p.y);
}

void Turtle::moveRel(float dx, float dy)
{
  cp.set(cp.x + dx, cp.y + dy);
}

//draws a line from current position to new point
void Turtle::lineTo(float x, float y)
{
  glBegin(GL_LINES);
    glVertex2f((GLfloat) cp.x, (GLfloat) cp.y);
    glVertex2f((GLfloat) x, (GLfloat) y); //draw the line
  glEnd();
  cp.set (x, y); //update current position to new point
  glFlush();
}

//draws a line from current position to new point
void Turtle::lineTo(Point2 p)
{
  glBegin (GL_LINES);
    glVertex2f((GLfloat) cp.x, (GLfloat) cp.y);
    glVertex2f((GLfloat) p.x, (GLfloat) p.y);
  glEnd();
  cp.set(p.x, p.y);
  glFlush();
}

//turns to the specific direction
void Turtle::turnTo( float a )
{
  angle = a;   //set current direction
}

//pointing towards p
void Turtle::turnTo( Point2 p )
{
  if ( p.x == cp.x && p.y == cp.y )
    angle = 0;
  else {
    if ( cp.x == p.x ) {
      if ( p.y < cp.y )
        angle = -90;
      else
        angle = 90;
    }else {
        float a = atan ( (p.y - cp.y) /(p.x - cp.x) );  //find angle
        angle = 180 * a / 3.1415926;    //convert to degree 
    }
  }
}

//Turn for a certain degrees
void Turtle::turn( float a )
{
  angle += a;  //turn anti-clockwise 
}

//move line forward by amount dist, if isVisible nonzero, line is drawn
void Turtle::forward ( float dist, int isVisible )
{
  const float radPerDeg = 0.017453393;    //radians per degree = 3.14159265389/180
  float  x = cp.x + dist * cos ( radPerDeg * angle );
  float  y = cp.y + dist * sin ( radPerDeg * angle );
  
  //special treatment for 0 and 90 degrees for better results
  if ( ( (int) angle % 180 )  == 0 ) 
    y = cp.y;
  else if ( (int) angle % 90 == 0 ) 
    x = cp.x;
   
  if ( isVisible )
    lineTo( x, y );
  else
    moveTo ( x, y );
}

