/*
 *  boxes.cpp
 *  Drawing box and window using turtle graphics.
 */
#include <GL/glut.h>
#include <stdlib.h>
#include "turtle.h"

using namespace std;

Turtle turtle;

void text18 ( char *s )
{
  char *p;

  for ( p = s; *p; p++ )
    glutBitmapCharacter ( GLUT_BITMAP_HELVETICA_18, *p );
}

void init(void) 
{
   glClearColor (1.0, 1.0, 1.0, 0.0);
   glShadeModel (GL_FLAT);
}

void box()
{
  for ( int i = 0; i < 4; i++ ) {
    turtle.forward( 80, 1);
    turtle.turn( 90 ); 
  }
}

void display(void)
{
   int i;
   glClear (GL_COLOR_BUFFER_BIT);
   glColor3f (0.0, 0.0, 0.0);
   glLineWidth( 2 );
   Point2 p1 (100, 200); 
   turtle.moveTo ( p1 );     
   box();    //draw box
   //draw window
   Point2 p2 ( 300, 280 );  //window center
   turtle.moveTo ( p2 );     
   for ( int i = 0; i < 4; i++ ){
     box();
     turtle.turn ( 90 );   
   }
   //label the images
   glRasterPos2f( p1.x+25, p1.y-20 );
   text18 ( "Box" );
   glRasterPos2f( p2.x-35, p2.y-100 );
   text18 ( "Window" );

   glFlush();
   
}

void reshape (int w, int h)
{
   glViewport (0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode (GL_PROJECTION);
   glLoadIdentity ();
   gluOrtho2D (0.0, (GLdouble) w, 0.0, (GLdouble) h);
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500); 
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display); 
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}
