//primitives.cpp: primitives of OpenGL
#include <GL/glut.h>
#include <stdio.h>

using namespace std;

//initialization
void init( void )
{
  glClearColor( 1.0, 1.0, 1.0, 0.0 );	//get white background color
  glColor3f( 0.0f, 0.0f, 0.0f );	//set drawing color to black
  glPointSize( 4.0 );			//a dot is 4x4 pixels
  glMatrixMode( GL_PROJECTION );        //matrix for projection
  glLoadIdentity();                     //load identity matrix
  gluOrtho2D( 0.0, 500.0, 0.0, 500.0 ); //2D 500x500 world window
}

void text ( char *s )
{
  char *p;

  for ( p = s; *p; p++ )
    glutBitmapCharacter ( GLUT_BITMAP_HELVETICA_12, *p );
}

void text18 ( char *s )
{
  char *p;

  for ( p = s; *p; p++ )
    glutBitmapCharacter ( GLUT_BITMAP_HELVETICA_18, *p );
}
 
void label_vertex( char *s0, int vp[][2], int x0, int y0, int N )
{ 
  glColor3f ( 0.0, 0.0, 0.0 );
  glRasterPos2i (x0, y0 );
  text( s0 );
  char s[100];
  s[2] = 0;
  for ( int i = 0; i < N; i++ ) {
     if ( i==0 && N > 6 ) printf("vp: (%d,%d)\n", vp[i][0], vp[i][1] );
     glRasterPos2i (vp[i][0], vp[i][1] );
     sprintf( s, "v%1d", i );
     text( s );
  }
}

void draw ( int type, int mode, int v[][2], int n )
{
  glPolygonMode( GL_FRONT, mode );
  glPolygonMode( GL_BACK, mode );
  glBegin ( type );
    for ( int i = 0; i < n; i++ )
      glVertex2iv( v[i] );

  glEnd();
}


void display( void )
{
  glClear( GL_COLOR_BUFFER_BIT );	//clear screen
  
  int v[6][2] = {{20,40}, {50, 40}, {20, 70}, {60, 60}, {40, 120}, {100, 80}};
  int vp[8][2];    //label positions
  int posx = 5;
  int n;

  n = 6;
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = v[i][0];
    vp[i][1] = v[i][1];
  }
  vp[0][0] -= 15;
  vp[1][0] += 5;
  vp[2][0] -= 15;
  vp[3][0] += 12;
  vp[3][1] -= 5;
  vp[5][1] += 3;

  label_vertex( "GL_TRIANGLES", vp, posx, 20, n );
  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_TRIANGLES, GL_FILL, v, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_TRIANGLES, GL_LINE, v, n );
  
  glPushMatrix();

  glTranslatef( 150, 0, 0 );
  label_vertex( "GL_TRIANGLE_STRIP", vp, posx, 20, n );

  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_TRIANGLE_STRIP, GL_FILL, v, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_TRIANGLE_STRIP, GL_LINE, v, n );

  glTranslatef( 150, 0, 0 );
  n = 5;
  int vf[5][2] = {{20,40}, {20, 120}, {60, 110}, {100, 80}, {90, 50}};
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = vf[i][0];
    vp[i][1] = vf[i][1];
  }
  vp[0][0] -= 15;
  vp[1][1] += 3;
  vp[4][0] += 5;
  label_vertex( "GL_TRIANGLE_FAN", vp, posx, 20, n );
  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_TRIANGLE_FAN, GL_FILL, vf, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_TRIANGLE_FAN, GL_LINE, vf, n );
  
  //next row
  glPopMatrix();
  glPushMatrix();
  n = 5;
  glTranslatef( 0, 130, 0 );
  label_vertex( "GL_POLYGON", vp, posx, 20, n );
  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_POLYGON, GL_FILL, vf, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_POLYGON, GL_LINE, vf, n );
  
  glTranslatef( 150, 0, 0 );
  n = 8;
  int vq[8][2] = {{20,40}, {20, 120}, {60, 110}, {50, 60}, {70, 50}, {100, 50}, {100,90}, {80, 100}};
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = vq[i][0];
    vp[i][1] = vq[i][1];
  }
  vp[0][0] -= 15;
  vp[1][1] += 5;
  vp[3][0] += 5;
  vp[4][1] -= 12;
  vp[5][0] += 5;
  label_vertex( "GL_QUADS", vp, posx, 20, n );
  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_QUADS, GL_FILL, vq, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_QUADS, GL_LINE, vq, n );
 
  glTranslatef( 150, 0, 0 );
  n = 8;
  int vqs[8][2] = {{20,40}, {20, 120}, {50, 60}, {60, 110},  {70, 50}, {80, 100},{100, 50}, {110,90} };
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = vqs[i][0];
    vp[i][1] = vqs[i][1];
  }
  vp[0][0] -= 15;
  vp[1][1] += 5;
  vp[2][0] -= 3;
  vp[2][1] -= 13;
  vp[3][0] += 5;
  vp[4][1] -= 12;
  vp[5][0] += 5;
  vp[6][0] += 3;
  label_vertex( "GL_QUAD_STRIP", vp, posx, 20, n );
  glColor3f ( 0.8, 0.8, 0.8 );
  draw ( GL_QUAD_STRIP, GL_FILL, vqs, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_QUAD_STRIP, GL_LINE, vqs, n );

  //top row
  glPopMatrix();
  glTranslatef( 0, 260, 0 );
  n = 6;
  int vl[6][2] = {{20,40}, {50, 40}, {20, 70}, {60, 60}, {40, 120}, {100, 80}};
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = vl[i][0];
    vp[i][1] = vl[i][1];
  }
  vp[0][0] -= 15;
  vp[1][0] += 5;
  vp[2][0] -= 15;
  vp[3][0] += 12;
  vp[3][1] -= 5;
  vp[5][1] += 3;
  label_vertex( "GL_LINES", vp, posx, 20, n );
  glColor3f( 0, 0, 0 );
  draw ( GL_LINES, GL_LINE, vl, n );
  
  glTranslatef( 150, 0, 0 );
  label_vertex( "GL_LINE_STRIP", vp, posx, 20, n );
  draw ( GL_LINE_STRIP, GL_LINE, vl, n );
  
  glTranslatef( 150, 0, 0 );
  int vll[6][2] = {{50, 40},{20,40},  {20, 70}, {60, 60}, {40, 120}, {100, 80}};
  for ( int i = 0; i < n;  i++ ) {
    vp[i][0] = vll[i][0];
    vp[i][1] = vll[i][1];
  }
  vp[1][0] -= 15;
  vp[0][0] += 5;
  label_vertex( "GL_LINE_LOOP", vp, posx, 20, n );
  draw ( GL_LINE_LOOP, GL_LINE, vll, n );
  glFlush();				//send all output to screen
}


/*  Main Loop
 *  Open window with initial window size, title bar, 
 *  RGBA display mode, depth buffer.
 */
int main(int argc, char** argv)
{
  glutInit(&argc, argv);	        //initialize toolkit
  glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB ); //set display mode
  glutInitWindowSize(500, 500);		//set window size on screen
  glutInitWindowPosition( 100, 150 ); 	//set window position on screen
  glutCreateWindow(argv[0]);		//open screen widow
  init();                               //customized initialization
  glutDisplayFunc (display);		//points to display function
  glutMainLoop();			//go into perpetual loop
  return 0;
}
