//polygon_modes.cpp
#include <GL/glut.h>
#include <stdio.h>

using namespace std;

//initialization
void init( void )
{
  glClearColor( 1.0, 1.0, 1.0, 0.0 );	//get white background color
  glColor3f( 0.0f, 0.0f, 0.0f );	//set drawing color to black
  glPointSize( 4.0 );			//a dot is 4x4 pixels
  glMatrixMode( GL_PROJECTION );        //matrix for projection
  glLoadIdentity();                     //load identity matrix
  gluOrtho2D( 0.0, 500.0, 0.0, 500.0 ); //2D 500x500 world window
}

void text18 ( char *s )
{
  char *p;

  for ( p = s; *p; p++ )
    glutBitmapCharacter ( GLUT_BITMAP_HELVETICA_18, *p );
}
  
void drawPolygon ( int mode, char *s )
{
  glPolygonMode( GL_FRONT, mode );
  glBegin( GL_POLYGON );                
    glVertex2i( 30, 30 );
    glVertex2i( 100, 30 );  
    glVertex2i( 150, 60 );   
    glVertex2i( 130, 130 );  
    glVertex2i( 70, 100 );
  glEnd();
  glRasterPos2i ( 90, 10 );
  text18 ( s );
}
 
void display( void )
{
  glClear( GL_COLOR_BUFFER_BIT );	//clear screen
  int x0, y0; 
  glColor3f( 1.0, 0.0, 0.0 );           //red
  drawPolygon( GL_FILL, "(a)" );	//draw solid polygon
  
  glTranslatef(160, 0, 0);		//draw at different position
  glColor3f( 0.0, 1.0, 0.0 );           //green
  drawPolygon( GL_LINE, "(b)" );	//draw polygon outline
    
  glTranslatef(160, 0, 0);		//draw at different position
  glColor3f( 0.0, 0.0, 1.0 );           //blue
  drawPolygon( GL_POINT, "(c)" );	//draw polygon points

  glFlush();  
}

int main(int argc, char** argv)
{
  glutInit(&argc, argv);	        //initialize toolkit
  glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB ); //set display mode
  glutInitWindowSize(500, 500);		//set window size on screen
  glutInitWindowPosition( 100, 150 ); 	//set window position on screen
  glutCreateWindow(argv[0]);		//open screen widow
  init();                               //customized initialization
  glutDisplayFunc (display);		//points to display function
  glutMainLoop();			//go into perpetual loop
  return 0;
}
