//draw.cpp : demo program for drawing 3 dots, two lines, ploylines, rectangles
#include <GL/glut.h>
#include <stdio.h>

//initialization
void init( void )
{
  glClearColor( 1.0, 1.0, 1.0, 0.0 );	//get white background color
  glColor3f( 0.0f, 0.0f, 0.0f );	//set drawing color to black
  glPointSize( 4.0 );			//a dot is 4x4 pixels
  glMatrixMode( GL_PROJECTION );        //matrix for projection
  glLoadIdentity();                     //load identity matrix
  gluOrtho2D( 0.0, 300.0, 0.0, 300.0 ); //2D 500x500 world window
}

void display( void )
{
  glClear( GL_COLOR_BUFFER_BIT );	//clear screen

  glBegin( GL_POINTS );			//draw points
    glVertex2i( 100, 50 );		//draw a point at (100, 50)
    glVertex2i( 100, 150 );		//draw a point
    glVertex2i( 200, 200 );		//draw a point
  glEnd();

  //Two points specify a line.
  glBegin( GL_LINES );			//draw lines
    glVertex2i( 20, 20 );		//horizontal line
    glVertex2i( 250, 20 );
    glVertex2i( 20, 10 );		//vertical line
    glVertex2i( 20, 250 );
  glEnd();

  //draw line connecting all points
  glBegin( GL_LINE_STRIP );		//draw polyline
    glVertex2i( 100, 100 );
    glVertex2i( 200, 50 );
    glVertex2i( 250, 100 );
    glVertex2i( 100, 50 );
  glEnd();

  glColor3f( 0.6, 0.6, 0.6 );		//bright grey color

  glRecti( 200, 200, 250, 280 );

  glFlush();				//send all output to screen
}


/*  Main Loop
 *  Open window with initial window size, title bar, 
 *  RGBA display mode, depth buffer.
 */
int main(int argc, char** argv)
{
  glutInit(&argc, argv);	        //initialize toolkit
  glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB ); //set display mode
  glutInitWindowSize(300, 300);		//set window size on screen
  glutInitWindowPosition( 100, 150 ); 	//set window position on screen
  glutCreateWindow(argv[0]);		//open screen widow
  init();                               //customized initialization
  glutDisplayFunc (display);		//points to display function
  glutMainLoop();			//go into perpetual loop
  return 0;
}
