/* vase.cpp
 * Render a vase by surface of revolution.
 * Surface is generated by revolving a curve around x-axis.                    
 * C functions of vector operators are defined in Vector3.cpp of Chapter 12
 * Fore June
 */

#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "Vector3.h"  //in ../12

using namespace std;

static const double PI = 3.14159265389;

//Function defining profile of revolution
double f1 ( double x )
{
  double y = 2 + sin ( x );

  return y;
}

void vase(int nx, int ntheta, float startx, float endx )
{
   const float dx = (endx - startx)/nx; //x step size
   const float dtheta = 2*PI / ntheta;  //angular step size
   float theta = PI/2.0;                //from pi/2 to3pi/2

   int i, j;
   float x, y, z, r;                    //current coordinates
   float x1, y1, z1, r1;                //next coordinates
   float t, v[3];
   double va[3], vb[3], vc[3], normal[3];
   int nturn = 0;
   x = startx;
   r = f1 ( x );
   bool first_point = true;
   for ( int si = 1; si <= nx; si++ ) {
      theta = 0;
      int start=0, nn=60, end=nn;
      x1 = x + dx;
      r1 = f1 ( x1 );
      //draw the surface composed of quadrilaterals by sweeping theta
      glBegin( GL_QUAD_STRIP );
      for ( j = 0; j <= ntheta; ++j ) {
        theta += dtheta;
        double cosa = cos( theta );
        double sina = sin ( theta );
        y = r * cosa;  y1 = r1 * cosa;  //current and next y 
        z = r * sina;    z1 = r1 * sina;        //current and next z
        if ( nturn == 0 ) {
          va[0] = x;   va[1] = y;     va[2] = z;
          vb[0] = x1;  vb[1] = y1;    vb[2] = z1;
          nturn++;
        } else {
          nturn = 0;
          vc[0] = x;    vc[1] = y;    vc[2] = z;
          plane_normal ( normal, va, vb, vc );
          glNormal3f ( normal[0], normal[1], normal[2] );
        }
        //edge from point at x to point at next x
        glVertex3f (x, y, z);
        glVertex3f (x1, y1, z1);
        //forms quad with next pair of points with incremented theta value      
      }
      glEnd();
      x = x1;
      r = r1;
   } //for k 
}

//Draw a vase
void aVase()
{
   int theVase = glGenLists (1);
   glNewList( theVase, GL_COMPILE);
     vase ( 32, 64, 0, 5 );
   glEndList();

   glCallList ( theVase );
}
