/*
 *  stencil-demo.cpp
 *  This program demonstrates the use of the stencil buffer to
 *  mask  pixels for rendering.  
 *  Whenever the window is redrawn, a value of 1 is drawn 
 *  into a triangular-region in the stencil buffer and  0
 *  elsewhere.
 *  Fore June
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>

void init (void) 
{
   glEnable ( GL_DEPTH_TEST );
   glEnable ( GL_STENCIL_TEST );
   glClearColor (1.0f, 1.0f, 1.0f, 0.0f);
   glClearStencil ( 0x0 );
}

void drawSquare( float z )
{
  glBegin ( GL_POLYGON );
      glVertex3f (-1.0, 1.0, z);
      glVertex3f (1.0, 1.0, z);
      glVertex3f (1.0, -1.0, z);
      glVertex3f (-1.0, -1.0, z);
   glEnd();
}

void drawTriangle( float z )
{
  glBegin ( GL_POLYGON );
      glVertex3f ( 0.0,  0.0, z );	
      glVertex3f (-1.0, -1.0, z );
      glVertex3f ( 1.0, -1.0, z );
   glEnd();
}

//green triangle inside red square
void display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
   glClear(GL_STENCIL_BUFFER_BIT);  //fill stencil buffer with 0s
   glStencilFunc (GL_ALWAYS, 0x1, 0x1);
   glStencilOp (GL_REPLACE, GL_REPLACE, GL_REPLACE);
   drawTriangle( -0.5 );  //stencil buffer will have triangle region filled with 1s
                          //  but outside triangle, stencil values  are 0   

   glStencilFunc ( GL_NOTEQUAL, 0x1, 0x1 );//fail inside triangle, pass outside
		                           // so triangle region won't be rendered
   glStencilOp ( GL_KEEP, GL_KEEP, GL_KEEP );	//no change in stencil buffer values
  						
   glColor3f ( 1, 0, 0 );			//red
   drawSquare( -0.5 );                          //z = -0.5, 
   glStencilFunc ( GL_EQUAL, 0x1, 0x1 );	//pass in triangular-region, fail outside
   glStencilOp ( GL_KEEP, GL_KEEP, GL_KEEP );	//no change in stencil buffer values
   glColor3f ( 0, 1, 0 );			//green
   drawSquare ( 0 );                            //z = 0, so in front of red square
   glFlush();
}

/*  
 *  Called at startup and whenever the window is reshaped, 
 */
void reshape ( int w, int h )
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      gluOrtho2D(-3.0, 3.0, -3.0*(GLfloat)h/(GLfloat)w,
                 3.0*(GLfloat)h/(GLfloat)w);
   else
      gluOrtho2D(-3.0*(GLfloat)w/(GLfloat)h,
                 3.0*(GLfloat)w/(GLfloat)h, -3.0, 3.0);

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

/* Main Loop
 * Be certain to request stencil bits.
 */
int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB 
                        | GLUT_DEPTH | GLUT_STENCIL);
   glutInitWindowSize (400, 400);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutReshapeFunc(reshape);
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   glutMainLoop();
   return 0;
}

