/*
 * redner.cpp
 * Render a seashell or pawns or a vase.
 * Fore June
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glut.h>
#include <algorithm>
#include <iostream>
#include <vector>
#include "Point3.h"   //in directory ../12
#include "Vector3.h"  //in directory ../12

using namespace std;

void threePawns();
void seaShell();
void aVase();

int anglex= 8, angley = 16, anglez = 0; 
char showType = 's';  //showing seashell or pawns

/*
   Initialization.
   This is where global OpenGL/GLUT settings are made. 
*/
void init(void)
{
   glEnable(GL_DEPTH_TEST);
   glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
   glFrontFace(GL_CW);
   glClearColor(1.0, 1.0, 1.0, 0.0);
   glEnable( GL_CULL_FACE );
   glCullFace ( GL_BACK );
   glPolygonMode( GL_FRONT, GL_FILL );
   glShadeModel(GL_SMOOTH);
  
   //lighting
   GLfloat mat_specular[] = { 0.6, 1.0, 0.8, 1.0 };
   GLfloat mat_diffuse[] = { 0.6, 1.0, 0.8, 1.0 };
   GLfloat mat_shininess[] = { 50.0 };
   GLfloat light[] = { 0.6, 1.0, 0.7 };
   GLfloat light1[] = { 0.7, 0.9, 0.6 };
   GLfloat light_position[] = {0, 1.0, 1.0, 0.0 };
   GLfloat light_position1[] = { -1.0, -1.0, -1.0, 0.0 };
   GLfloat lmodel_ambient[] = { 0.4, 0.8, 0.6, 1.0 };

   glShadeModel (GL_SMOOTH);
   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
   glLightfv(GL_LIGHT0, GL_POSITION, light_position);
   glLightfv(GL_LIGHT1, GL_POSITION, light_position1);

   glLightfv(GL_LIGHT0, GL_DIFFUSE, light );
   glLightfv(GL_LIGHT0, GL_SPECULAR, light );
   glLightfv(GL_LIGHT1, GL_DIFFUSE, light1 );
   glLightfv(GL_LIGHT1, GL_SPECULAR, light1 );
   glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_LIGHT1);
   glEnable(GL_DEPTH_TEST);
   printf("\nPress 'p' to display 3 pawns, \n      's' to display seashell,");
   printf("\n      'v' to display vase,    \n      'x', 'y', 'z' to rotate scene.\n");
}

void rotate()
{
   glRotatef( anglex, 1.0, 0.0, 0.0);   //rotate the object about x-axis
   glRotatef( angley, 0.0, 1.0, 0.0);   //rotate about y-axis   
   glRotatef( anglez, 0.0, 0.0, 1.0);   //rotate about z-axis
}

void drawScene(void)
{ 
  glPushMatrix(); 
  rotate();
  if ( showType == 'p' )  
    threePawns();
  else if ( showType == 's' )
    seaShell();
  else
    aVase();

  glPopMatrix();
}

/*
   This is the basic display callback routine.
*/
void display(void)
{
   glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glFrustum ( -1.6, 1.6, -1.2, 1.2, 2.0, 1000.0 );
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt( 0, 0, 10, 0, 0, 0, 0, 1, 0 );

   drawScene();
   glFlush();

   glutSwapBuffers(); 
}

void keyboard(unsigned char key,int x, int y)
{
   switch (key) {
   case 27:        //ESC  ( quit )
   case 'Q':
   case 'q': 
      exit(0); 
    case 'x':
      anglex = ( anglex + 3 ) % 360;
      break;
    case 'X':
      anglex = ( anglex - 3 ) % 360;
      break;
    case 'y':
      angley = ( angley + 3 ) % 360;
      break;
    case 'Y':
      angley = ( angley - 3 ) % 360;
      break;
    case 'z':
      anglez = ( anglez + 3 ) % 360;
      break;
    case 'Z':
      anglez = ( anglez - 3 ) % 360;
      break;
    case 'r':                                   //reset
      anglez = angley = anglex = 0;
      glLoadIdentity();
      break;
    case 'p':
      showType = 'p';
      anglex = angley = anglez = 0;
      break;
    case 's':
      showType = 's';
      anglex = 9; angley = 16;  anglez = 0;
      break;
    case 'v' :
      showType = 'v';
      anglex = angley = anglez = 0;
      break;
   }
   glutPostRedisplay();
}

int main(int argc,char **argv)
{
   // Set things (glut) up 
   glutInit(&argc,argv);
   glutInitDisplayMode( GLUT_DOUBLE | GLUT_DEPTH );

   // Create the window and handlers 
   glutCreateWindow("Seashell,  Pawns and Vase");
   glutReshapeWindow( 800, 600 );
   glutInitWindowPosition(100, 100);
   glutDisplayFunc(display);
   glutKeyboardFunc(keyboard);
   init();
   //perpetual loop
   glutMainLoop();
   return(0);
}
