
/*  polyint.cpp			
 *  This program demonstrates using polynomial interpretation to draw a curve.
 *  Fore June
 */
#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include "Point3.h"

using namespace std;

GLdouble ctrlpoints[4][3] = {
	{ -4.0, -4.0, 0.0}, { -2.0, 4.0, 0.0}, 
	{2.0, -4.0, 0.0}, {4.0, 4.0, 0.0}};

void init(void)
{
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
}


//Langrange polynomial interpretation for N points
double polyint ( Point3  points[], double x, int N )
{
  double y;

  double num = 1.0;	//numerator
  double den = 1.0;	//denominator
  double sum = 0.0;

  for ( int i = 0; i < N; ++i ) {
    num = den = 1.0;
    for ( int j = 0; j < N; ++j ) {
      if ( j == i ) continue;

      num = num * ( x - points[j].x );		 	//x - xj
    }
    for ( int j = 0; j < N; ++j ) {
      if ( j == i ) continue;
      den = den * ( points[i].x - points[j].x );	//xi - xj
    }
    sum += num / den * points[i].y;
  }
  y = sum;

  return y;
}

void display(void)
{
   int i;
   double x, y;

   glClear(GL_COLOR_BUFFER_BIT);
   glColor3f(1.0, 1.0, 1.0);
   Point3 data[4];
   for ( i = 0; i < 4; i++ )
     data[i] = Point3( ctrlpoints[i][0], ctrlpoints[i][1], ctrlpoints[i][2] );
   glBegin(GL_LINE_STRIP);

      for (i = -40; i <= 40; i++) {
	 x = (double) i /10.0;
	 y = polyint ( data, x, 4 );
	 glVertex2d ( x, y );
      }
   glEnd();
   /* The following code displays the control points as dots. */
   glPointSize(5.0);
   glColor3f(1.0, 1.0, 0.0);
   glBegin(GL_POINTS);
      for (i = 0; i < 4; i++) 
         glVertex3dv(&ctrlpoints[i][0]);
   glEnd();
   glFlush();
}

void reshape(int w, int h)
{
   glViewport(0, 0, (GLsizei) w, (GLsizei) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
      glOrtho(-5.0, 5.0, -5.0*(GLfloat)h/(GLfloat)w, 
               5.0*(GLfloat)h/(GLfloat)w, -5.0, 5.0);
   else
      glOrtho(-5.0*(GLfloat)w/(GLfloat)h, 
               5.0*(GLfloat)w/(GLfloat)h, -5.0, 5.0, -5.0, 5.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_SINGLE | GLUT_RGB);
   glutInitWindowSize (500, 500);
   glutInitWindowPosition (100, 100);
   glutCreateWindow (argv[0]);
   init ();
   glutDisplayFunc(display);
   glutReshapeFunc(reshape);
   glutKeyboardFunc (keyboard);
   glutMainLoop();
   return 0;
}
