/**
 * readxml.cpp 
 * (Adopted from "reader1.c" of http://xmlsoft.org/examples.) 
 * Parse an XML file with an xmlReader from file "cube.dae" 
 * usage: ./readxml
 * Most likely, your system already has libxml2 installed.
 * If not, download it from http://xmlsoft.org and install it.
 */

#include <stdio.h>
#include <libxml/xmlreader.h>

using namespace std;

// Print information about the current node
void processNode(xmlTextReaderPtr reader) 
{
    const xmlChar *name, *value;

    name = xmlTextReaderConstName(reader);
    if (name == NULL)
	name = (xmlChar *) "--";

    value = xmlTextReaderConstValue(reader);
    static int count = 0;		//count line number
    count++;		
    printf("%4d: %d %d %s %d %d", count, 
	    xmlTextReaderDepth(reader),
	    xmlTextReaderNodeType(reader),
	    name,
	    xmlTextReaderIsEmptyElement(reader),
	    xmlTextReaderHasValue(reader));
    if (value == NULL)
	printf("\n");
    else {
        if (xmlStrlen(value) > 40)
            printf("    value= %.40s...\n", value);
        else
	    printf("    value= %s\n", value);
    }
}


int main() 
{
    // Initializes library and check whether correct version is used.
    LIBXML_TEST_VERSION
   
    const char filename[] = "cube.dae"; 
    xmlTextReaderPtr reader = xmlReaderForFile( filename, NULL, 0 );
    if ( reader == NULL ) {
        fprintf(stderr, "Unable to open %s\n", filename);
        return 1;
    }

    int ret = xmlTextReaderRead(reader);
    while (ret == 1) {
        processNode(reader);
        ret = xmlTextReaderRead(reader);
    }
    xmlFreeTextReader(reader);
    if (ret != 0) {
      fprintf(stderr, "%s : failed to parse\n", filename);
    }

    //Cleanup function for the XML library.
    xmlCleanupParser();
    
    return 0;
}

