/*
 * accumtest.cpp : 
 * Color blending of three partially overlap triangles using accumulation buffer.
 */
#include <GL/glut.h>
#include <stdlib.h>

//initialization
void init( void )
{
  glClearColor( 1.0, 1.0, 1.0, 0.0 );	//get white background color
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  gluOrtho2D( 0.0, 400.0, 0.0, 400.0 );
}

void draw_triangle()
{
  glBegin( GL_TRIANGLES );			
    glVertex2i( 100, 100 );
    glVertex2i( 100, 300 );		
    glVertex2i( 300, 300 );		
  glEnd();

}

void setColor( int i )
{
  switch ( i ){
  case 0:
    glColor3f( 1, 0, 0 );
    break;
  case 1:
    glColor3f( 0, 1, 0 );
    break;
  case 2:
    glColor3f( 0, 0, 1 );
    break;
  default:
    glColor3f( 0, 0, 0 );
    break; 
  }
}

void display( void )
{
  glClear(GL_ACCUM_BUFFER_BIT);
  for ( int i = 0; i < 3; i++ ) {
    glClear(GL_COLOR_BUFFER_BIT);//clear screen
    glPushMatrix();
    glRotatef ( i*5.0, 0, 0, 1 );
    setColor ( i );
    draw_triangle();
    glPopMatrix();
    glAccum(GL_ACCUM, 0.33);     //accumulate color data
  }
  glClear(GL_COLOR_BUFFER_BIT);  //clear screen
  glAccum(GL_RETURN, 1.0);       //render data saved in accumulation buffer

  glutSwapBuffers();
  glFlush();                     //send all output to screen
}

void keyboard(unsigned char key, int x, int y)
{
   switch (key) {
      case 27:
         exit(0);
         break;
   }
}

int main(int argc, char** argv)
{
  glutInit(&argc, argv);	      //initialize toolkit
  glutInitDisplayMode (GLUT_RGB | GLUT_ACCUM);	//set display mode with 
  glutInitWindowSize( 400, 400);      //set window size on screen
  glutInitWindowPosition( 500, 250 ); //set window position on screen
  glutCreateWindow(argv[0]);          //open screen window
  init();
  glutDisplayFunc (display);          //points to display function
  glutKeyboardFunc(keyboard);
  glutMainLoop();                     //go into perpetual loop
  return 0;
}
